/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.jdbc;

import java.io.Closeable;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRoutingDataSource
implements DataSource,
Closeable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        throw new UnsupportedOperationException("setLoginTimeout");
    }

    @Override
    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException("getLogWriter");
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        return this.determineTargetDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.determineTargetDataSource().isWrapperFor(iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDataSourceNumber(String prefix) {
        try {
            Properties properties = System.getProperties();
            synchronized (properties) {
                String name = this.getClass().getName() + ".datasource_number";
                String next = String.valueOf(Integer.getInteger(name, 0) + 1);
                System.setProperty(name, next);
                return prefix + next;
            }
        }
        catch (AccessControlException e) {
            this.logger.warn("The SecurityManager didn't allow us to read/write system properties, so just generate a random DataSource number instead", (Throwable)e);
            return prefix + RandomStringUtils.randomAlphanumeric((int)4);
        }
    }

    protected abstract DataSource determineTargetDataSource();

    @Override
    public java.util.logging.Logger getParentLogger() {
        return java.util.logging.Logger.getLogger("global");
    }
}

