/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.jdbc;

import app.myoss.cloud.datasource.routing.context.DataSourceNameContextHolder;
import app.myoss.cloud.datasource.routing.jdbc.AbstractRoutingDataSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDataSource
extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(MultiDataSource.class);
    private String name;
    @NonNull
    private String primaryDataSourceName;
    @NonNull
    private Map<String, DataSource> targetDataSources;

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String prefix = "MultiDataSource-";
        this.name = this.getDataSourceNumber("MultiDataSource-");
        return this.name;
    }

    @Override
    public void close() throws IOException {
        this.logger.info("{} - Shutdown initiated...", (Object)this.getName());
        for (Map.Entry<String, DataSource> entry : this.targetDataSources.entrySet()) {
            DataSource value = entry.getValue();
            if (!(value instanceof Closeable)) continue;
            ((Closeable)((Object)value)).close();
        }
        this.targetDataSources.clear();
        this.logger.info("{} - Shutdown completed.", (Object)this.getName());
    }

    @Override
    protected DataSource determineTargetDataSource() {
        DataSource dataSource;
        String dataSourceName = DataSourceNameContextHolder.peek();
        if (StringUtils.isBlank((CharSequence)dataSourceName)) {
            dataSourceName = this.primaryDataSourceName;
        }
        if ((dataSource = this.targetDataSources.get(dataSourceName)) == null) {
            throw new IllegalStateException("Cannot find DataSource [" + dataSourceName + "]");
        }
        return dataSource;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrimaryDataSourceName(@NonNull String primaryDataSourceName) {
        if (primaryDataSourceName == null) {
            throw new NullPointerException("primaryDataSourceName is marked @NonNull but is null");
        }
        this.primaryDataSourceName = primaryDataSourceName;
    }

    public void setTargetDataSources(@NonNull Map<String, DataSource> targetDataSources) {
        if (targetDataSources == null) {
            throw new NullPointerException("targetDataSources is marked @NonNull but is null");
        }
        this.targetDataSources = targetDataSources;
    }

    @NonNull
    public String getPrimaryDataSourceName() {
        return this.primaryDataSourceName;
    }

    @NonNull
    public Map<String, DataSource> getTargetDataSources() {
        return this.targetDataSources;
    }

    public MultiDataSource(@NonNull String primaryDataSourceName, @NonNull Map<String, DataSource> targetDataSources) {
        if (primaryDataSourceName == null) {
            throw new NullPointerException("primaryDataSourceName is marked @NonNull but is null");
        }
        if (targetDataSources == null) {
            throw new NullPointerException("targetDataSources is marked @NonNull but is null");
        }
        this.primaryDataSourceName = primaryDataSourceName;
        this.targetDataSources = targetDataSources;
    }
}

