/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.spring.boot.autoconfigure;

import app.myoss.cloud.datasource.routing.annotation.DataSource;
import app.myoss.cloud.datasource.routing.aspectj.DataSourceAnnotationInterceptor;
import app.myoss.cloud.datasource.routing.aspectj.DataSourceMethodPointcutAdvisorDynamicBeanRegistry;
import app.myoss.cloud.datasource.routing.aspectj.DataSourcePointcutAdvisor;
import app.myoss.cloud.datasource.routing.spring.boot.autoconfigure.DataSourceRoutingProperties;
import app.myoss.cloud.datasource.routing.spring.boot.jdbc.DataSourceBuilder;
import app.myoss.cloud.datasource.routing.spring.boot.jdbc.impl.MultiDataSourceBuilder;
import java.util.Collection;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

@ConditionalOnProperty(prefix="myoss-cloud.datasource-routing", value={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={DataSourceRoutingProperties.class})
@AutoConfigureOrder(value=-1000)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@AutoConfigureAfter(value={RefreshAutoConfiguration.class})
@Configuration
public class DataSourceRoutingAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DataSourceRoutingAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public DataSourceBuilder dataSourceBuilder(DataSourceRoutingProperties dataSourceRoutingProperties) {
        return new MultiDataSourceBuilder(dataSourceRoutingProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourcePointcutAdvisor dataSourcePointcutAdvisor(DataSourceRoutingProperties dataSourceRoutingProperties) {
        DataSourceAnnotationInterceptor interceptor = new DataSourceAnnotationInterceptor();
        AnnotationMatchingPointcut classPointCut = new AnnotationMatchingPointcut(DataSource.class, true);
        AnnotationMatchingPointcut methodPointcut = AnnotationMatchingPointcut.forMethodAnnotation(DataSource.class);
        ComposablePointcut pointcut = new ComposablePointcut((Pointcut)classPointCut).union((Pointcut)methodPointcut);
        DataSourcePointcutAdvisor pointcutAdvisor = new DataSourcePointcutAdvisor((Pointcut)pointcut, (Advice)interceptor);
        pointcutAdvisor.setOrder(dataSourceRoutingProperties.getDataSourcePointcutAdvisorOrder());
        return pointcutAdvisor;
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceMethodPointcutAdvisorDynamicBeanRegistry dataSourceMethodPointcutAdvisorDynamicBeanRegistry(Environment environment) {
        DataSourceRoutingProperties dataSourceRoutingProperties = new DataSourceRoutingProperties();
        Binder binder = Binder.get((Environment)environment);
        binder.bind("myoss-cloud.datasource-routing", Bindable.ofInstance((Object)dataSourceRoutingProperties));
        DataSourceMethodPointcutAdvisorDynamicBeanRegistry registry = new DataSourceMethodPointcutAdvisorDynamicBeanRegistry();
        registry.setDataSourceRoutingProperties(dataSourceRoutingProperties);
        return registry;
    }

    @ConditionalOnBean(value={org.springframework.cloud.context.scope.refresh.RefreshScope.class})
    @Configuration
    public static class SpringCloudProjectAutoConfiguration {
        @Autowired
        private DataSourceBuilder dataSourceBuilder;

        @RefreshScope
        @Primary
        @Bean
        @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
        public javax.sql.DataSource dataSource(DataSourceBuilder dataSourceBuilder) {
            return dataSourceBuilder.build();
        }

        @EventListener
        public void onEnvironmentChangeEvent(EnvironmentChangeEvent event) {
            Set keys = event.getKeys();
            if (CollectionUtils.isEmpty((Collection)keys)) {
                return;
            }
            StringBuilder changed = new StringBuilder();
            for (String key : keys) {
                if (!key.startsWith("myoss-cloud.datasource-routing")) continue;
                changed.append(key).append(", ");
            }
            int length = changed.length();
            if (length > 0) {
                log.info("Refresh keys changed: {}", (Object)changed.delete(length - 3, length));
                this.dataSourceBuilder.onEnvironmentChangeEvent(event);
            }
        }
    }

    @ConditionalOnMissingBean(type={"org.springframework.cloud.context.scope.refresh.RefreshScope"})
    @Configuration
    public static class NotSpringCloudProjectAutoConfiguration {
        @Primary
        @Bean
        @ConditionalOnMissingBean(value={javax.sql.DataSource.class})
        public javax.sql.DataSource dataSource(DataSourceBuilder dataSourceBuilder) {
            return dataSourceBuilder.build();
        }
    }
}

