/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.spring.boot.jdbc.impl;

import app.myoss.cloud.datasource.routing.config.DataSourceProperty;
import app.myoss.cloud.datasource.routing.config.GroupDataSourceProperty;
import app.myoss.cloud.datasource.routing.jdbc.GroupDataSource;
import app.myoss.cloud.datasource.routing.jdbc.MultiDataSource;
import app.myoss.cloud.datasource.routing.jdbc.loadbalancer.DataSourceLoadBalancer;
import app.myoss.cloud.datasource.routing.spring.boot.autoconfigure.DataSourceRoutingProperties;
import app.myoss.cloud.datasource.routing.spring.boot.jdbc.DataSourceBuilder;
import app.myoss.cloud.datasource.routing.spring.boot.jdbc.impl.DefaultDataSourceBuilder;
import app.myoss.cloud.datasource.routing.spring.boot.jdbc.impl.JndiDataSourceBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;

public class MultiDataSourceBuilder
implements DataSourceBuilder,
ApplicationContextAware,
BeanClassLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(MultiDataSourceBuilder.class);
    private JndiDataSourceBuilder jndiDataSourceBuilder;
    private ApplicationContext applicationContext;
    private ClassLoader beanClassLoader;
    @NonNull
    private DataSourceRoutingProperties dataSourceRoutingProperties;

    @Override
    public DataSource build() {
        Map<String, Object> globalDatabaseProperties = this.dataSourceRoutingProperties.getGlobalDatabaseProperties();
        List<DataSourceProperty> databases = this.dataSourceRoutingProperties.getDatabases();
        LinkedHashMap<String, DataSource> targetDataSources = new LinkedHashMap<String, DataSource>();
        LinkedMultiValueMap targetGroupDataSources = new LinkedMultiValueMap();
        String primaryDataSourceName = null;
        for (DataSourceProperty item : databases) {
            DataSource result;
            String name = item.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException("Property 'name' is required");
            }
            if (item.isPrimary()) {
                if (primaryDataSourceName != null) {
                    throw new IllegalArgumentException("Property 'primary' is already set 'true' in DataSource [" + primaryDataSourceName + "]");
                }
                primaryDataSourceName = name;
            }
            if (StringUtils.isNotBlank((CharSequence)item.getJndiName())) {
                if (this.jndiDataSourceBuilder == null) {
                    this.jndiDataSourceBuilder = new JndiDataSourceBuilder();
                }
                result = this.jndiDataSourceBuilder.build(item.getJndiName());
            } else {
                Map<String, Object> properties = this.mergeGlobalDatabaseProperties(globalDatabaseProperties, item);
                DefaultDataSourceBuilder<? extends DataSource> dataSourceBuilder = DefaultDataSourceBuilder.create(properties, this.beanClassLoader).type(item.getType()).name(name).url(item.getUrl()).driverClassName(item.getDriverClassName()).username(item.getUsername()).password(item.getPassword());
                result = dataSourceBuilder.build();
            }
            DataSource previous = targetDataSources.putIfAbsent(name, result);
            if (previous != null) {
                throw new IllegalArgumentException("Property 'name' is already set '" + name + "'");
            }
            String groupName = item.getGroupName();
            if (!StringUtils.isNotBlank((CharSequence)groupName)) continue;
            targetGroupDataSources.add((Object)groupName, (Object)result);
        }
        GroupDataSourceProperty groupDataSourceConfig = this.dataSourceRoutingProperties.getGroupDataSourceConfig();
        Map<String, GroupDataSourceProperty> groupDataSourceConfigs = this.dataSourceRoutingProperties.getGroupDataSourceConfigs();
        for (Map.Entry entry : targetGroupDataSources.entrySet()) {
            String groupName = (String)entry.getKey();
            GroupDataSourceProperty groupConfig = groupDataSourceConfig;
            if (!CollectionUtils.isEmpty(groupDataSourceConfigs) && groupDataSourceConfigs.containsKey(groupName)) {
                groupConfig = groupDataSourceConfigs.get(groupName);
            }
            DataSourceLoadBalancer dataSourceLoadBalancer = (DataSourceLoadBalancer)BeanUtils.instantiateClass(groupConfig.getLoadBalancer());
            dataSourceLoadBalancer.init(groupConfig.getInitConfig());
            GroupDataSource groupDataSource = new GroupDataSource(groupName, dataSourceLoadBalancer, (List)entry.getValue());
            DataSource previous = targetDataSources.putIfAbsent(groupName, groupDataSource);
            if (previous == null) continue;
            throw new IllegalArgumentException("Property 'name' or 'groupName' is already set '" + groupName + "'");
        }
        return new MultiDataSource(primaryDataSourceName, targetDataSources);
    }

    private Map<String, Object> mergeGlobalDatabaseProperties(Map<String, Object> globalDatabaseProperties, DataSourceProperty item) {
        Map<String, Object> properties = item.getProperties();
        if (globalDatabaseProperties != null) {
            if (properties == null) {
                return new LinkedHashMap<String, Object>(globalDatabaseProperties);
            }
            for (Map.Entry<String, Object> entry : globalDatabaseProperties.entrySet()) {
                String key = entry.getKey();
                if (properties.containsKey(key)) continue;
                Object value = entry.getValue();
                properties.put(key, value);
            }
        }
        if (properties == null) {
            properties = new LinkedHashMap<String, Object>(8);
        }
        return properties;
    }

    @Override
    public void onEnvironmentChangeEvent(Object event) {
        Binder binder = Binder.get((Environment)this.applicationContext.getEnvironment());
        binder.bind("myoss-cloud.datasource-routing", Bindable.ofInstance((Object)this.dataSourceRoutingProperties));
    }

    public void setJndiDataSourceBuilder(JndiDataSourceBuilder jndiDataSourceBuilder) {
        this.jndiDataSourceBuilder = jndiDataSourceBuilder;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void setDataSourceRoutingProperties(@NonNull DataSourceRoutingProperties dataSourceRoutingProperties) {
        if (dataSourceRoutingProperties == null) {
            throw new NullPointerException("dataSourceRoutingProperties is marked @NonNull but is null");
        }
        this.dataSourceRoutingProperties = dataSourceRoutingProperties;
    }

    public JndiDataSourceBuilder getJndiDataSourceBuilder() {
        return this.jndiDataSourceBuilder;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    @NonNull
    public DataSourceRoutingProperties getDataSourceRoutingProperties() {
        return this.dataSourceRoutingProperties;
    }

    public MultiDataSourceBuilder(@NonNull DataSourceRoutingProperties dataSourceRoutingProperties) {
        if (dataSourceRoutingProperties == null) {
            throw new NullPointerException("dataSourceRoutingProperties is marked @NonNull but is null");
        }
        this.dataSourceRoutingProperties = dataSourceRoutingProperties;
    }
}

