/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.support.mybatis.plugin;

import app.myoss.cloud.datasource.routing.context.DataSourceNameContextHolder;
import java.util.Properties;
import lombok.NonNull;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MasterSlaveDataSourcePlugin
implements Interceptor {
    private Properties properties;
    private boolean init;
    @NonNull
    private String master = "master";
    @NonNull
    private String slave = "slave";

    public MasterSlaveDataSourcePlugin(String master, String slave) {
        this.master = master;
        this.slave = slave;
        this.init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        try {
            if (!this.init && this.properties != null) {
                this.master = this.properties.getProperty("master", "master");
                this.slave = this.properties.getProperty("slave", "slave");
                this.init = true;
            }
            String dataSourceName = SqlCommandType.SELECT == ms.getSqlCommandType() ? this.slave : this.master;
            DataSourceNameContextHolder.push(dataSourceName);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DataSourceNameContextHolder.clear();
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked @NonNull but is null");
        }
        this.properties = properties;
    }

    public MasterSlaveDataSourcePlugin() {
    }

    public void setInit(boolean init) {
        this.init = init;
    }
}

