/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.aspectj;

import app.myoss.cloud.datasource.routing.annotation.DataSource;
import app.myoss.cloud.datasource.routing.context.DataSourceNameContextHolder;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.AnnotationUtils;

public class DataSourceAnnotationInterceptor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        DataSource dataSource = (DataSource)AnnotationUtils.findAnnotation((Method)method, DataSource.class);
        if (dataSource == null) {
            dataSource = (DataSource)AnnotationUtils.findAnnotation(method.getDeclaringClass(), DataSource.class);
        }
        String name = dataSource.name();
        try {
            DataSourceNameContextHolder.push(name);
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            DataSourceNameContextHolder.pop();
        }
    }
}

