/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.aspectj;

import app.myoss.cloud.datasource.routing.aspectj.DataSourceMethodPointcutInterceptor;
import app.myoss.cloud.datasource.routing.aspectj.DataSourcePointcutAdvisor;
import app.myoss.cloud.datasource.routing.config.MethodPointcutProperty;
import app.myoss.cloud.datasource.routing.constants.MethodPointcutEnum;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.JdkRegexpMethodPointcut;

public final class DataSourceMethodPointcutAdvisorBuilder {
    public static List<DataSourcePointcutAdvisor> create(LinkedHashMap<String, List<MethodPointcutProperty>> allMethodPointcuts, int pointCutOrder) {
        HashMap duplicateExpressionCheck = new HashMap(16);
        HashMap matchMethod = new HashMap(24);
        return allMethodPointcuts.entrySet().stream().map(entry -> {
            String dataSourceName = (String)entry.getKey();
            return ((List)entry.getValue()).stream().map(item -> {
                ComposablePointcut composablePointcut = null;
                MethodPointcutEnum type = item.getType();
                Set<String> expressions = item.getExpressions();
                for (String expression : expressions) {
                    String previous = duplicateExpressionCheck.putIfAbsent(expression.trim(), dataSourceName);
                    if (previous != null) {
                        throw new IllegalArgumentException("Method pointcut expression [" + expression + "] is already use DataSource '" + previous + "', cannot set another DataSource '" + dataSourceName + "'");
                    }
                    Pointcut pointcut = DataSourceMethodPointcutAdvisorBuilder.buildPointcut(dataSourceName, matchMethod, type, expression);
                    if (composablePointcut == null) {
                        composablePointcut = new ComposablePointcut(pointcut);
                        continue;
                    }
                    composablePointcut.union(pointcut);
                }
                DataSourcePointcutAdvisor pointcutAdvisor = new DataSourcePointcutAdvisor(dataSourceName, (Pointcut)composablePointcut, (Advice)new DataSourceMethodPointcutInterceptor(dataSourceName));
                pointcutAdvisor.setOrder(pointCutOrder);
                return pointcutAdvisor;
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Pointcut buildPointcut(final String dataSourceName, final Map<String, String> matchMethod, MethodPointcutEnum type, String expression) {
        if (type == MethodPointcutEnum.AspectJExpression) {
            AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut(){
                private static final long serialVersionUID = 308965026639128900L;

                public boolean matches(Method method, Class<?> targetClass, boolean hasIntroductions) {
                    if (super.matches(method, targetClass, hasIntroductions)) {
                        String methodQualified = targetClass.getName() + "." + method.getName();
                        String previous = matchMethod.putIfAbsent(methodQualified, dataSourceName);
                        if (previous != null && !previous.equals(dataSourceName)) {
                            throw new IllegalArgumentException("Method [" + methodQualified + "] is already use DataSource '" + previous + "', cannot set another DataSource '" + dataSourceName + "'");
                        }
                        return true;
                    }
                    return false;
                }
            };
            pointcut.setExpression(expression);
            return pointcut;
        }
        if (type == MethodPointcutEnum.JdkRegexpMethod) {
            JdkRegexpMethodPointcut pointcut = new JdkRegexpMethodPointcut(){
                private static final long serialVersionUID = -2853478842657883590L;

                protected boolean matches(String pattern, int patternIndex) {
                    if (super.matches(pattern, patternIndex)) {
                        String previous = matchMethod.putIfAbsent(pattern, dataSourceName);
                        if (previous != null && !previous.equals(dataSourceName)) {
                            throw new IllegalArgumentException("Method [" + pattern + "] is already use DataSource '" + previous + "', cannot set another DataSource '" + dataSourceName + "'");
                        }
                        return true;
                    }
                    return false;
                }
            };
            pointcut.setPatterns(new String[]{expression});
            return pointcut;
        }
        throw new UnsupportedOperationException("MethodPointcutEnum: " + (Object)((Object)type));
    }

    private DataSourceMethodPointcutAdvisorBuilder() {
    }
}

