/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.jdbc;

import app.myoss.cloud.datasource.routing.jdbc.AbstractRoutingDataSource;
import app.myoss.cloud.datasource.routing.jdbc.loadbalancer.DataSourceLoadBalancer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import javax.sql.DataSource;
import lombok.NonNull;

public class GroupDataSource
extends AbstractRoutingDataSource {
    @NonNull
    private String groupName;
    @NonNull
    private DataSourceLoadBalancer dataSourceLoadBalancer;
    @NonNull
    private List<DataSource> targetDataSources;

    @Override
    public void close() throws IOException {
        this.logger.info("GroupDataSource: {} - Shutdown initiated...", (Object)this.groupName);
        for (DataSource value : this.targetDataSources) {
            if (!(value instanceof Closeable)) continue;
            ((Closeable)((Object)value)).close();
        }
        this.targetDataSources.clear();
        this.logger.info("GroupDataSource: {} - Shutdown completed.", (Object)this.groupName);
    }

    @Override
    protected DataSource determineTargetDataSource() {
        DataSource dataSource = this.dataSourceLoadBalancer.determineDataSource(this.targetDataSources);
        if (dataSource == null) {
            throw new IllegalStateException("Cannot determine target DataSource");
        }
        return dataSource;
    }

    public void setGroupName(@NonNull String groupName) {
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        this.groupName = groupName;
    }

    public void setDataSourceLoadBalancer(@NonNull DataSourceLoadBalancer dataSourceLoadBalancer) {
        if (dataSourceLoadBalancer == null) {
            throw new NullPointerException("dataSourceLoadBalancer is marked non-null but is null");
        }
        this.dataSourceLoadBalancer = dataSourceLoadBalancer;
    }

    public void setTargetDataSources(@NonNull List<DataSource> targetDataSources) {
        if (targetDataSources == null) {
            throw new NullPointerException("targetDataSources is marked non-null but is null");
        }
        this.targetDataSources = targetDataSources;
    }

    @NonNull
    public String getGroupName() {
        return this.groupName;
    }

    @NonNull
    public DataSourceLoadBalancer getDataSourceLoadBalancer() {
        return this.dataSourceLoadBalancer;
    }

    @NonNull
    public List<DataSource> getTargetDataSources() {
        return this.targetDataSources;
    }

    public GroupDataSource(@NonNull String groupName, @NonNull DataSourceLoadBalancer dataSourceLoadBalancer, @NonNull List<DataSource> targetDataSources) {
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (dataSourceLoadBalancer == null) {
            throw new NullPointerException("dataSourceLoadBalancer is marked non-null but is null");
        }
        if (targetDataSources == null) {
            throw new NullPointerException("targetDataSources is marked non-null but is null");
        }
        this.groupName = groupName;
        this.dataSourceLoadBalancer = dataSourceLoadBalancer;
        this.targetDataSources = targetDataSources;
    }
}

