/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.datasource.routing.spring.boot.jdbc.impl;

import app.myoss.cloud.datasource.routing.spring.boot.jdbc.DataSourceBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.util.ClassUtils;

public final class DefaultDataSourceBuilder<T extends DataSource>
implements DataSourceBuilder {
    private static final String[] DATA_SOURCE_TYPE_NAMES = new String[]{"com.zaxxer.hikari.HikariDataSource", "com.alibaba.druid.pool.DruidDataSource", "org.apache.tomcat.jdbc.pool.DataSource", "org.apache.commons.dbcp2.BasicDataSource"};
    private Class<? extends DataSource> type;
    private ClassLoader classLoader;
    private Map<String, Object> properties;

    public static DefaultDataSourceBuilder<?> create() {
        return new DefaultDataSourceBuilder(new HashMap<String, Object>(8), null);
    }

    public static DefaultDataSourceBuilder<?> create(Map<String, Object> properties) {
        return new DefaultDataSourceBuilder(properties, null);
    }

    public static DefaultDataSourceBuilder<?> create(ClassLoader classLoader) {
        return new DefaultDataSourceBuilder(new HashMap<String, Object>(8), classLoader);
    }

    public static DefaultDataSourceBuilder<?> create(Map<String, Object> properties, ClassLoader classLoader) {
        return new DefaultDataSourceBuilder(properties, classLoader);
    }

    private DefaultDataSourceBuilder(Map<String, Object> properties, ClassLoader classLoader) {
        this.properties = properties;
        this.classLoader = classLoader;
    }

    public T build() {
        Class<DataSource> type = this.getType();
        DataSource result = (DataSource)BeanUtils.instantiateClass(type);
        this.maybeGetDriverClassName();
        this.bind(result);
        return (T)result;
    }

    private void maybeGetDriverClassName() {
        if (!this.properties.containsKey("driverClassName") && this.properties.containsKey("url")) {
            String url = (String)this.properties.get("url");
            String driverClass = DatabaseDriver.fromJdbcUrl((String)url).getDriverClassName();
            this.properties.put("driverClassName", driverClass);
        }
    }

    private void bind(DataSource result) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(this.properties);
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        aliases.addAliases("url", new String[]{"jdbc-url"});
        aliases.addAliases("username", new String[]{"user"});
        aliases.addAliases("name", new String[]{"pool-name"});
        Binder binder = new Binder(new ConfigurationPropertySource[]{source.withAliases(aliases)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)result));
    }

    public <D extends DataSource> DefaultDataSourceBuilder<D> type(Class<D> type) {
        this.type = type;
        return this;
    }

    public DefaultDataSourceBuilder<T> name(String name) {
        this.properties.put("name", name);
        return this;
    }

    public DefaultDataSourceBuilder<T> url(String url) {
        this.properties.put("url", url);
        return this;
    }

    public DefaultDataSourceBuilder<T> driverClassName(String driverClassName) {
        this.properties.put("driverClassName", driverClassName);
        return this;
    }

    public DefaultDataSourceBuilder<T> username(String username) {
        this.properties.put("username", username);
        return this;
    }

    public DefaultDataSourceBuilder<T> password(String password) {
        this.properties.put("password", password);
        return this;
    }

    public static Class<? extends DataSource> findType(ClassLoader classLoader) {
        for (String name : DATA_SOURCE_TYPE_NAMES) {
            try {
                return ClassUtils.forName((String)name, (ClassLoader)classLoader);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private Class<? extends DataSource> getType() {
        Class<? extends DataSource> type;
        Class<? extends DataSource> clazz = type = this.type != null ? this.type : DefaultDataSourceBuilder.findType(this.classLoader);
        if (type != null) {
            return type;
        }
        throw new IllegalStateException("No supported DataSource type found");
    }
}

