/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.generator;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.core.lang.base.StringUtil;
import app.myoss.cloud.core.lang.bean.BeanUtil;
import app.myoss.cloud.core.lang.io.FileUtil;
import app.myoss.cloud.mybatis.generator.config.ColumnOverride;
import app.myoss.cloud.mybatis.generator.config.Configuration;
import app.myoss.cloud.mybatis.generator.config.ExtendedFile;
import app.myoss.cloud.mybatis.generator.config.TableConfiguration;
import app.myoss.cloud.mybatis.generator.db.Column;
import app.myoss.cloud.mybatis.generator.db.IndexInfo;
import app.myoss.cloud.mybatis.generator.db.SqlKeyWords;
import app.myoss.cloud.mybatis.generator.db.Table;
import app.myoss.cloud.mybatis.generator.db.dialect.DatabaseDialect;
import app.myoss.cloud.mybatis.generator.db.dialect.DatabaseDialects;
import app.myoss.cloud.mybatis.generator.template.TemplateEngine;
import app.myoss.cloud.mybatis.generator.template.impl.FreemarkerTemplateImpl;
import app.myoss.cloud.mybatis.generator.types.JavaTypeResolver;
import app.myoss.cloud.mybatis.generator.types.impl.FullyQualifiedJavaType;
import app.myoss.cloud.mybatis.generator.types.impl.JavaTypeResolverImpl;
import app.myoss.cloud.mybatis.mapper.template.CrudMapper;
import app.myoss.cloud.mybatis.repository.service.CrudService;
import app.myoss.cloud.mybatis.repository.service.impl.BaseCrudServiceImpl;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class MyBatisGenerator {
    private static final Logger log = LoggerFactory.getLogger(MyBatisGenerator.class);
    private Configuration configuration;
    private TemplateEngine templateEngine;
    private List<ExtendedFile> extendedFiles;

    public MyBatisGenerator(Configuration configuration) {
        this.configuration = configuration;
    }

    public void generate() {
        this.initConfiguration();
        List<TableConfiguration> tableConfigurations = this.configuration.getTableConfigurations();
        ArrayList<Table> tables = new ArrayList<Table>(tableConfigurations.size());
        DataSource dataSource = this.configuration.getDataSource();
        try {
            Connection connection = dataSource.getConnection();
            Object object = null;
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (this.configuration.getDatabaseDialects() == null) {
                    String databaseProductName = databaseMetaData.getDatabaseProductName();
                    DatabaseDialects databaseDialect = DatabaseDialects.getDatabaseDialect(databaseProductName);
                    this.configuration.setDatabaseDialects(databaseDialect);
                }
                Objects.requireNonNull(this.configuration.getDatabaseDialects(), "Cannot resolve DatabaseDialects");
                for (TableConfiguration tc : tableConfigurations) {
                    Table table = this.initTableInformation(tc, databaseMetaData);
                    tables.add(table);
                }
            }
            catch (Throwable databaseMetaData) {
                object = databaseMetaData;
                throw databaseMetaData;
            }
            finally {
                if (connection != null) {
                    if (object != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable databaseMetaData) {
                            ((Throwable)object).addSuppressed(databaseMetaData);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BizRuntimeException((Throwable)e);
        }
        if (this.templateEngine == null) {
            this.templateEngine = new FreemarkerTemplateImpl();
        }
        this.templateEngine.init(this.configuration);
        Path rootOutputPath = Paths.get(this.configuration.getRootOutputPath(), new String[0]);
        for (Table table : tables) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("configuration", this.configuration);
            data.put("table", table);
            this.generateEntity(rootOutputPath, table, data);
            this.generateDto(rootOutputPath, table, data);
            this.generateConverter(rootOutputPath, table, data);
            this.generateMapperInterface(rootOutputPath, table, data);
            this.generateMapperXml(rootOutputPath, table, data);
            this.generateServiceInterface(rootOutputPath, table, data);
            this.generateServiceImplInterface(rootOutputPath, table, data);
            this.generateWeb(rootOutputPath, table, data);
            if (CollectionUtils.isEmpty(this.extendedFiles)) continue;
            for (ExtendedFile extendedFile : this.extendedFiles) {
                extendedFile.generateFile(this.templateEngine, rootOutputPath, table, data);
            }
        }
    }

    public String resolveFilePath(Path rootOutputPath, String childOutputPath, String packageName, String fileName) {
        String tmp = packageName.replace(".", File.separator);
        Path path = StringUtils.isNotBlank((CharSequence)childOutputPath) ? rootOutputPath.resolve(childOutputPath + File.separator + tmp) : rootOutputPath.resolve(tmp);
        return FileUtil.createDirectories((Path)path).resolve(fileName + ".java").toString();
    }

    public void generateEntity(Path rootOutputPath, Table table, HashMap<String, Object> data) {
        String filePath = this.resolveFilePath(rootOutputPath, table.getEntityOutputPath(), table.getEntityPackageName(), table.getEntityName());
        this.templateEngine.writer(table.getEntityTemplatePath(), filePath, data);
    }

    public void generateDto(Path rootOutputPath, Table table, HashMap<String, Object> data) {
        String filePath = this.resolveFilePath(rootOutputPath, table.getDtoOutputPath(), table.getDtoPackageName(), table.getDtoName());
        this.templateEngine.writer(table.getDtoTemplatePath(), filePath, data);
    }

    public void generateConverter(Path rootOutputPath, Table table, HashMap<String, Object> data) {
        String filePath = this.resolveFilePath(rootOutputPath, table.getConverterOutputPath(), table.getConverterPackageName(), table.getConverterName());
        this.templateEngine.writer(table.getConverterTemplatePath(), filePath, data);
    }

    public void generateMapperInterface(Path rootOutputPath, Table table, HashMap<String, Object> data) {
        String filePath = this.resolveFilePath(rootOutputPath, table.getMapperOutputPath(), table.getMapperPackageName(), table.getMapperName());
        this.templateEngine.writer(table.getMapperTemplatePath(), filePath, data);
    }

    public void generateMapperXml(Path rootOutputPath, Table table, HashMap<String, Object> data) {
        Path path;
        String mapperXMLOutputPath = table.getMapperXMLOutputPath();
        if (StringUtils.isNotBlank((CharSequence)mapperXMLOutputPath)) {
            path = rootOutputPath.resolve(mapperXMLOutputPath);
            String tmp = StringUtils.substringAfterLast((String)StringUtils.removeEnd((String)table.getMapperPackageName(), (String)".mapper"), (String)".");
            String tmp2 = StringUtils.substringAfterLast((String)mapperXMLOutputPath, (String)File.separator);
            if (StringUtils.isNotBlank((CharSequence)tmp) && !StringUtils.equals((CharSequence)mapperXMLOutputPath, (CharSequence)tmp) && !StringUtils.equals((CharSequence)tmp, (CharSequence)tmp2)) {
                path = path.resolve(tmp);
            }
        } else {
            path = rootOutputPath.resolve(table.getMapperPackageName().replace(".", File.separator)).resolve("xml");
        }
        String filePath = FileUtil.createDirectories((Path)path).resolve(table.getMapperName() + ".xml").toString();
        this.templateEngine.writer(table.getMapperXMLTemplatePath(), filePath, data);
    }

    public void generateServiceInterface(Path rootOutputPath, Table table, HashMap<String, Object> data) {
        String filePath = this.resolveFilePath(rootOutputPath, table.getServiceOutputPath(), table.getServicePackageName(), table.getServiceName());
        this.templateEngine.writer(table.getServiceTemplatePath(), filePath, data);
    }

    public void generateServiceImplInterface(Path rootOutputPath, Table table, HashMap<String, Object> data) {
        String filePath = this.resolveFilePath(rootOutputPath, table.getServiceImplOutputPath(), table.getServiceImplPackageName(), table.getServiceImplName());
        this.templateEngine.writer(table.getServiceImplTemplatePath(), filePath, data);
    }

    public void generateWeb(Path rootOutputPath, Table table, HashMap<String, Object> data) {
        String filePath = this.resolveFilePath(rootOutputPath, table.getWebOutputPath(), table.getWebPackageName(), table.getWebName());
        this.templateEngine.writer(table.getWebTemplatePath(), filePath, data);
    }

    public void initConfiguration() {
        String copyright;
        Objects.requireNonNull(this.configuration, "configuration is null");
        Objects.requireNonNull(this.configuration.getRootOutputPath(), "rootOutputPath is null");
        Objects.requireNonNull(this.configuration.getDataSource(), "dataSource is null");
        if (StringUtils.isBlank((CharSequence)this.configuration.getAuthor())) {
            throw new NullPointerException("author is null or empty");
        }
        List<TableConfiguration> tableConfigurations = this.configuration.getTableConfigurations();
        if (CollectionUtils.isEmpty(tableConfigurations)) {
            throw new NullPointerException("tableConfigurations is null or empty");
        }
        boolean allColumnDelimitingEnabled = BooleanUtils.isTrue((Boolean)this.configuration.getAllColumnDelimitingEnabled());
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (TableConfiguration tc : tableConfigurations) {
            String rootPackageName;
            String serviceImplSuperClass;
            String serviceSuperClass;
            String mapperSuperClass;
            tc.setProperties(this.configuration.getProperties());
            String tableName = tc.getTableName();
            if (StringUtils.isBlank((CharSequence)tableName)) {
                throw new NullPointerException("tableConfiguration.tableName is null or empty");
            }
            BeanUtil.copyProperties((Object)this.configuration, (Object)tc, null, (boolean)false, (String[])new String[0]);
            if (allColumnDelimitingEnabled) {
                tc.setAllColumnDelimitingEnabled(true);
            }
            String entityName = StringUtils.removeEnd((String)StringUtils.removeStart((String)StringUtil.toPascalCase((String)tableName), (String)tc.getRemoveEntityClassPrefix()), (String)tc.getRemoveEntityClassSuffix());
            if (StringUtils.isNotBlank((CharSequence)tc.getEntityClassPrefix())) {
                entityName = tc.getEntityClassPrefix() + entityName;
            }
            if (StringUtils.isNotBlank((CharSequence)tc.getEntityClassSuffix())) {
                entityName = entityName + tc.getEntityClassSuffix();
            }
            tc.setEntityName(entityName);
            String entitySuperClass = tc.getEntitySuperClass();
            if (StringUtils.isNotBlank((CharSequence)entitySuperClass)) {
                tc.setEntitySuperClass(StringUtils.substringAfterLast((String)entitySuperClass, (String)"."));
                tc.addEntityImportPackage(entitySuperClass);
                if (ClassUtils.isPresent((String)entitySuperClass, (ClassLoader)classLoader)) {
                    Class clazz = ClassUtils.resolveClassName((String)entitySuperClass, (ClassLoader)classLoader);
                    Map<String, Field> fields = this.getSuperClassFields(clazz);
                    tc.setEntitySuperClassFields(fields);
                } else {
                    log.warn("can not resolve class name [{}], ignored mark column is superClassField", (Object)entitySuperClass);
                }
            }
            if (StringUtils.isBlank((CharSequence)tc.getEntitySuperClass())) {
                tc.addEntityImportPackage("java.io.Serializable");
            }
            tc.setDtoName(tc.getEntityName() + (String)StringUtils.defaultIfBlank((CharSequence)tc.getDtoClassSuffix(), (CharSequence)"Dto"));
            tc.setConverterName(tc.getEntityName() + (String)StringUtils.defaultIfBlank((CharSequence)tc.getConverterClassSuffix(), (CharSequence)"Converter"));
            if (StringUtils.equals((CharSequence)this.configuration.getMapperName(), (CharSequence)tc.getMapperName()) && StringUtils.isNotBlank((CharSequence)this.configuration.getMapperName())) {
                tc.setMapperName(String.format(this.configuration.getMapperName(), tc.getEntityName()));
            } else if (StringUtils.isBlank((CharSequence)tc.getMapperName())) {
                tc.setMapperName(tc.getEntityName() + "Mapper");
            }
            if (StringUtils.isBlank((CharSequence)tc.getMapperSuperClass())) {
                tc.setMapperSuperClass(CrudMapper.class.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)(mapperSuperClass = tc.getMapperSuperClass()))) {
                tc.setMapperSuperClass(StringUtils.substringAfterLast((String)mapperSuperClass, (String)"."));
                tc.addMapperImportPackage(mapperSuperClass);
            }
            if (StringUtils.equals((CharSequence)this.configuration.getServiceName(), (CharSequence)tc.getServiceName()) && StringUtils.isNotBlank((CharSequence)this.configuration.getServiceName())) {
                tc.setServiceName(String.format(this.configuration.getServiceName(), tc.getEntityName()));
            } else if (StringUtils.isBlank((CharSequence)tc.getServiceName())) {
                tc.setServiceName(tc.getEntityName() + "Service");
            }
            if (StringUtils.isBlank((CharSequence)tc.getServiceSuperClass())) {
                tc.setServiceSuperClass(CrudService.class.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)(serviceSuperClass = tc.getServiceSuperClass()))) {
                tc.setServiceSuperClass(StringUtils.substringAfterLast((String)serviceSuperClass, (String)"."));
                tc.addServiceImportPackage(serviceSuperClass);
            }
            if (StringUtils.equals((CharSequence)this.configuration.getServiceImplName(), (CharSequence)tc.getServiceImplName()) && StringUtils.isNotBlank((CharSequence)this.configuration.getServiceImplName())) {
                tc.setServiceImplName(String.format(this.configuration.getServiceImplName(), tc.getEntityName()));
            } else if (StringUtils.isBlank((CharSequence)tc.getServiceImplName())) {
                tc.setServiceImplName(tc.getEntityName() + "ServiceImpl");
            }
            if (StringUtils.isBlank((CharSequence)tc.getServiceImplSuperClass())) {
                tc.setServiceImplSuperClass(BaseCrudServiceImpl.class.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)(serviceImplSuperClass = tc.getServiceImplSuperClass()))) {
                tc.setServiceImplSuperClass(StringUtils.substringAfterLast((String)serviceImplSuperClass, (String)"."));
                tc.addServiceImplImportPackage(serviceImplSuperClass);
            }
            if (StringUtils.equals((CharSequence)this.configuration.getWebName(), (CharSequence)tc.getWebName()) && StringUtils.isNotBlank((CharSequence)this.configuration.getWebName())) {
                tc.setWebName(String.format(this.configuration.getWebName(), tc.getEntityName()));
            } else if (StringUtils.isBlank((CharSequence)tc.getWebName())) {
                tc.setWebName(tc.getEntityName() + "Controller");
            }
            String webSuperClass = tc.getWebSuperClass();
            if (StringUtils.isNotBlank((CharSequence)webSuperClass)) {
                tc.setWebSuperClass(StringUtils.substringAfterLast((String)webSuperClass, (String)"."));
                tc.addWebImportPackage(webSuperClass);
            }
            if (StringUtils.isBlank((CharSequence)tc.getWebRequestName())) {
                tc.setWebRequestName(StringUtil.toCamelCase((String)tc.getEntityName()));
            }
            if (!StringUtils.isNotBlank((CharSequence)(rootPackageName = (String)StringUtils.defaultIfBlank((CharSequence)tc.getRootPackageName(), (CharSequence)this.configuration.getRootPackageName())))) continue;
            if (StringUtils.isBlank((CharSequence)tc.getEntityPackageName())) {
                tc.setEntityPackageName(rootPackageName + ".entity");
            }
            if (StringUtils.isBlank((CharSequence)tc.getDtoPackageName())) {
                tc.setDtoPackageName(rootPackageName + ".dto");
            }
            if (StringUtils.isBlank((CharSequence)tc.getConverterPackageName())) {
                tc.setConverterPackageName(rootPackageName + ".converter");
            }
            if (StringUtils.isBlank((CharSequence)tc.getMapperPackageName())) {
                tc.setMapperPackageName(rootPackageName + ".mapper");
            }
            if (StringUtils.isBlank((CharSequence)tc.getServicePackageName())) {
                tc.setServicePackageName(rootPackageName + ".service");
            }
            if (StringUtils.isBlank((CharSequence)tc.getServiceImplPackageName())) {
                tc.setServiceImplPackageName(rootPackageName + ".service.impl");
            }
            if (!StringUtils.isBlank((CharSequence)tc.getWebPackageName())) continue;
            tc.setWebPackageName(rootPackageName + ".web");
        }
        if (this.configuration.getJavaTypeResolver() == null) {
            JavaTypeResolverImpl javaTypeResolver = new JavaTypeResolverImpl();
            javaTypeResolver.addConfigurationProperties(this.configuration.getProperties());
            this.configuration.setJavaTypeResolver(javaTypeResolver);
        }
        this.configuration.setTodayYear(String.valueOf(LocalDate.now().getYear()));
        if (this.configuration.getGenerateDate() == null) {
            String generateDate = DateFormatUtils.format((Date)new Date(), (String)"yyyy\u5e74M\u6708d\u65e5 ah:mm:ss");
            generateDate = generateDate.replace("AM", "\u4e0a\u5348").replace("PM", "\u4e0b\u5348");
            this.configuration.setGenerateDate(generateDate);
        }
        if (StringUtils.isNotBlank((CharSequence)(copyright = this.configuration.getCopyright()))) {
            copyright = StringUtils.replace((String)copyright, (String)"${todayYear}", (String)this.configuration.getTodayYear());
            this.configuration.setCopyright(copyright);
        }
    }

    public Map<String, Field> getSuperClassFields(Class<?> clazz) {
        HashMap<String, Field> allFiledName = new HashMap<String, Field>();
        boolean isSupper = false;
        for (Class<?> currentClass = Objects.requireNonNull(clazz); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = currentClass.getDeclaredFields()) {
                String name = field.getName();
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || isSupper && allFiledName.containsKey(name)) continue;
                allFiledName.put(name, field);
            }
            isSupper = true;
        }
        return allFiledName;
    }

    private Table initTableInformation(TableConfiguration tc, DatabaseMetaData databaseMetaData) throws SQLException {
        String localTableName;
        String localSchema;
        String localCatalog;
        JavaTypeResolver javaTypeResolver = this.configuration.getJavaTypeResolver();
        DatabaseDialect databaseDialect = this.getDatabaseDialect();
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            localCatalog = tc.getCatalog() != null ? tc.getCatalog().toLowerCase() : null;
            localSchema = tc.getSchema() != null ? tc.getSchema().toLowerCase() : null;
            localTableName = tc.getTableName() != null ? tc.getTableName().toLowerCase() : null;
        } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
            localCatalog = tc.getCatalog() != null ? tc.getCatalog().toUpperCase() : null;
            localSchema = tc.getSchema() != null ? tc.getSchema().toUpperCase() : null;
            localTableName = tc.getTableName() != null ? tc.getTableName().toUpperCase() : null;
        } else {
            localCatalog = tc.getCatalog();
            localSchema = tc.getSchema();
            localTableName = tc.getTableName();
        }
        Table table = new Table();
        BeanUtil.copyProperties((Object)tc, (Object)table, null, (boolean)false, (String[])new String[0]);
        table.setProperties(tc.getProperties());
        ResultSet rs = databaseMetaData.getTables(localCatalog, localSchema, localTableName, null);
        if (rs.next()) {
            if (BooleanUtils.isTrue((Boolean)table.getUseCatalogOnGenerate())) {
                table.setCatalog(rs.getString("TABLE_CAT"));
            }
            if (BooleanUtils.isTrue((Boolean)table.getUseSchemaOnGenerate())) {
                table.setSchema(rs.getString("TABLE_SCHEM"));
            }
            table.setTableName(rs.getString("TABLE_NAME"));
            table.setRemarks(rs.getString("REMARKS"));
            table.setTableType(rs.getString("TABLE_TYPE"));
            if (StringUtils.isBlank((CharSequence)table.getEntityName())) {
                table.setEntityName(StringUtil.toCamelCase((String)table.getTableName()));
            }
        } else {
            log.warn("Cannot found table [{}] in database", (Object)localTableName);
        }
        this.closeResultSet(rs);
        rs = databaseMetaData.getColumns(localCatalog, localSchema, localTableName, "%");
        boolean supportsIsAutoIncrement = false;
        boolean supportsIsGeneratedColumn = false;
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int colCount = rsMetaData.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            if ("IS_AUTOINCREMENT".equals(rsMetaData.getColumnName(i))) {
                supportsIsAutoIncrement = true;
            }
            if (!"IS_GENERATEDCOLUMN".equals(rsMetaData.getColumnName(i))) continue;
            supportsIsGeneratedColumn = true;
        }
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            if (tc.isColumnIgnored(columnName)) continue;
            Column column = new Column();
            table.getColumns().add(column);
            column.setJdbcType(rs.getInt("DATA_TYPE"));
            column.setLength(rs.getInt("COLUMN_SIZE"));
            column.setColumnName(columnName);
            column.setNullable(rs.getInt("NULLABLE") == 1);
            column.setScale(rs.getInt("DECIMAL_DIGITS"));
            column.setRemarks(rs.getString("REMARKS"));
            column.setDefaultValue(rs.getString("COLUMN_DEF"));
            if (supportsIsAutoIncrement) {
                column.setAutoIncrement("YES".equals(rs.getString("IS_AUTOINCREMENT")));
                if (column.isAutoIncrement()) {
                    table.setAutoIncrement(true);
                }
            }
            if (supportsIsGeneratedColumn) {
                column.setGeneratedColumn("YES".equals(rs.getString("IS_GENERATEDCOLUMN")));
            }
            column.setJavaProperty(StringUtil.toCamelCase((String)columnName));
            column.setFullyQualifiedJavaType(javaTypeResolver.calculateJavaType(column));
            List<String> importList = column.getFullyQualifiedJavaType().getImportList();
            if (!CollectionUtils.isEmpty(importList)) {
                table.getEntityImportPackages().addAll(importList);
                table.addDtoImportPackage(importList);
            }
            column.setJdbcTypeName(javaTypeResolver.calculateJdbcTypeName(column));
            if (BooleanUtils.isTrue((Boolean)tc.getAllColumnDelimitingEnabled())) {
                column.setColumnNameDelimited(true);
            } else {
                column.setColumnNameDelimited(SqlKeyWords.containsWord(columnName));
            }
            String escapedColumnName = databaseDialect.getEscapedColumnName(table, column);
            if (!StringUtils.equals((CharSequence)columnName, (CharSequence)escapedColumnName)) {
                column.setEscapedColumnName(escapedColumnName);
            }
            if (tc.getEntitySuperClassFields() != null && tc.getEntitySuperClassFields().containsKey(column.getJavaProperty())) {
                column.setSuperClassField(true);
            }
            this.applyColumnOverrides(tc, column);
        }
        this.closeResultSet(rs);
        rs = databaseMetaData.getPrimaryKeys(localCatalog, localSchema, localTableName);
        TreeMap<Short, Object> keyColumns = new TreeMap<Short, Object>();
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            short keySeq = rs.getShort("KEY_SEQ");
            keyColumns.put(keySeq, columnName);
        }
        for (String columnName : keyColumns.values()) {
            table.addPrimaryKeyColumn(columnName);
        }
        this.closeResultSet(rs);
        rs = databaseMetaData.getIndexInfo(localCatalog, localSchema, localTableName, false, false);
        while (rs.next()) {
            IndexInfo indexInfo = new IndexInfo();
            indexInfo.setNonUnique(rs.getBoolean("NON_UNIQUE"));
            indexInfo.setIndexName(rs.getString("INDEX_NAME"));
            indexInfo.setType(rs.getInt("TYPE"));
            indexInfo.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
            indexInfo.setColumnName(rs.getString("COLUMN_NAME"));
            indexInfo.setAscOrDesc(rs.getString("ASC_OR_DESC"));
            table.addIndexColumn(indexInfo);
        }
        this.closeResultSet(rs);
        table.customize(tc);
        return table;
    }

    private void applyColumnOverrides(TableConfiguration tc, Column column) {
        ColumnOverride columnOverride = tc.getColumnOverride(column.getColumnName());
        if (columnOverride == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)columnOverride.getJavaProperty())) {
            column.setJavaProperty(columnOverride.getJavaProperty());
        }
        if (StringUtils.isNotBlank((CharSequence)columnOverride.getJavaType())) {
            column.setFullyQualifiedJavaType(new FullyQualifiedJavaType(columnOverride.getJavaType()));
        }
        if (StringUtils.isNotBlank((CharSequence)columnOverride.getJdbcType())) {
            column.setJdbcTypeName(columnOverride.getJdbcType());
        }
        if (StringUtils.isNotBlank((CharSequence)columnOverride.getTypeHandler())) {
            column.setTypeHandler(columnOverride.getTypeHandler());
        }
        if (columnOverride.isColumnNameDelimited()) {
            column.setColumnNameDelimited(true);
        }
        column.setGeneratedAlways(columnOverride.isGeneratedAlways());
        column.setProperties(columnOverride.getProperties());
        columnOverride.customize(tc, column);
    }

    public DatabaseDialect getDatabaseDialect() {
        DatabaseDialects databaseDialects = this.configuration.getDatabaseDialects();
        DatabaseDialect databaseDialect = DatabaseDialects.getDatabaseDialectMap().get((Object)databaseDialects);
        Objects.requireNonNull(databaseDialect);
        return databaseDialect;
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.warn("closeResultSet failed", (Throwable)e);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public List<ExtendedFile> getExtendedFiles() {
        return this.extendedFiles;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setExtendedFiles(List<ExtendedFile> extendedFiles) {
        this.extendedFiles = extendedFiles;
    }
}

