/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.generator.config;

import app.myoss.cloud.mybatis.generator.config.BaseConfiguration;
import app.myoss.cloud.mybatis.generator.config.ColumnOverride;
import app.myoss.cloud.mybatis.generator.config.IgnoredColumn;
import app.myoss.cloud.mybatis.generator.config.IgnoredColumnPattern;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TableConfiguration
extends BaseConfiguration {
    private String tableName;
    private Boolean ignoreQualifiersAtRuntime;
    private Map<String, ColumnOverride> columnOverrideMap;
    private Set<IgnoredColumn> ignoredColumns;
    private Set<IgnoredColumnPattern> ignoredColumnPatterns;

    public ColumnOverride getColumnOverride(String columnName) {
        return this.columnOverrideMap != null ? this.columnOverrideMap.get(columnName) : null;
    }

    public TableConfiguration addIgnoredColumn(String ... columnName) {
        if (this.ignoredColumns == null) {
            this.ignoredColumns = new LinkedHashSet<IgnoredColumn>();
        }
        for (String s : columnName) {
            IgnoredColumn ignoredColumn = new IgnoredColumn(s);
            this.ignoredColumns.add(ignoredColumn);
        }
        return this;
    }

    public TableConfiguration addIgnoredColumnPattern(String ... columnPattern) {
        if (this.ignoredColumnPatterns == null) {
            this.ignoredColumnPatterns = new LinkedHashSet<IgnoredColumnPattern>();
        }
        for (String s : columnPattern) {
            IgnoredColumnPattern ignoredColumnPattern = new IgnoredColumnPattern(s);
            this.ignoredColumnPatterns.add(ignoredColumnPattern);
        }
        return this;
    }

    public boolean isColumnIgnored(String columnName) {
        if (this.ignoredColumns != null) {
            for (IgnoredColumn ignoredColumn : this.ignoredColumns) {
                if (!ignoredColumn.matches(columnName)) continue;
                return true;
            }
        }
        if (this.ignoredColumnPatterns != null) {
            for (IgnoredColumnPattern ignoredColumnPattern : this.ignoredColumnPatterns) {
                if (!ignoredColumnPattern.matches(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableConfiguration)) {
            return false;
        }
        TableConfiguration other = (TableConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreQualifiersAtRuntime = this.getIgnoreQualifiersAtRuntime();
        Boolean other$ignoreQualifiersAtRuntime = other.getIgnoreQualifiersAtRuntime();
        if (this$ignoreQualifiersAtRuntime == null ? other$ignoreQualifiersAtRuntime != null : !((Object)this$ignoreQualifiersAtRuntime).equals(other$ignoreQualifiersAtRuntime)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        Map<String, ColumnOverride> this$columnOverrideMap = this.getColumnOverrideMap();
        Map<String, ColumnOverride> other$columnOverrideMap = other.getColumnOverrideMap();
        if (this$columnOverrideMap == null ? other$columnOverrideMap != null : !((Object)this$columnOverrideMap).equals(other$columnOverrideMap)) {
            return false;
        }
        Set<IgnoredColumn> this$ignoredColumns = this.getIgnoredColumns();
        Set<IgnoredColumn> other$ignoredColumns = other.getIgnoredColumns();
        if (this$ignoredColumns == null ? other$ignoredColumns != null : !((Object)this$ignoredColumns).equals(other$ignoredColumns)) {
            return false;
        }
        Set<IgnoredColumnPattern> this$ignoredColumnPatterns = this.getIgnoredColumnPatterns();
        Set<IgnoredColumnPattern> other$ignoredColumnPatterns = other.getIgnoredColumnPatterns();
        return !(this$ignoredColumnPatterns == null ? other$ignoredColumnPatterns != null : !((Object)this$ignoredColumnPatterns).equals(other$ignoredColumnPatterns));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreQualifiersAtRuntime = this.getIgnoreQualifiersAtRuntime();
        result = result * 59 + ($ignoreQualifiersAtRuntime == null ? 43 : ((Object)$ignoreQualifiersAtRuntime).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        Map<String, ColumnOverride> $columnOverrideMap = this.getColumnOverrideMap();
        result = result * 59 + ($columnOverrideMap == null ? 43 : ((Object)$columnOverrideMap).hashCode());
        Set<IgnoredColumn> $ignoredColumns = this.getIgnoredColumns();
        result = result * 59 + ($ignoredColumns == null ? 43 : ((Object)$ignoredColumns).hashCode());
        Set<IgnoredColumnPattern> $ignoredColumnPatterns = this.getIgnoredColumnPatterns();
        result = result * 59 + ($ignoredColumnPatterns == null ? 43 : ((Object)$ignoredColumnPatterns).hashCode());
        return result;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Boolean getIgnoreQualifiersAtRuntime() {
        return this.ignoreQualifiersAtRuntime;
    }

    public Map<String, ColumnOverride> getColumnOverrideMap() {
        return this.columnOverrideMap;
    }

    public Set<IgnoredColumn> getIgnoredColumns() {
        return this.ignoredColumns;
    }

    public Set<IgnoredColumnPattern> getIgnoredColumnPatterns() {
        return this.ignoredColumnPatterns;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setIgnoreQualifiersAtRuntime(Boolean ignoreQualifiersAtRuntime) {
        this.ignoreQualifiersAtRuntime = ignoreQualifiersAtRuntime;
    }

    public void setColumnOverrideMap(Map<String, ColumnOverride> columnOverrideMap) {
        this.columnOverrideMap = columnOverrideMap;
    }

    public void setIgnoredColumns(Set<IgnoredColumn> ignoredColumns) {
        this.ignoredColumns = ignoredColumns;
    }

    public void setIgnoredColumnPatterns(Set<IgnoredColumnPattern> ignoredColumnPatterns) {
        this.ignoredColumnPatterns = ignoredColumnPatterns;
    }

    @Override
    public String toString() {
        return "TableConfiguration(tableName=" + this.getTableName() + ", ignoreQualifiersAtRuntime=" + this.getIgnoreQualifiersAtRuntime() + ", columnOverrideMap=" + this.getColumnOverrideMap() + ", ignoredColumns=" + this.getIgnoredColumns() + ", ignoredColumnPatterns=" + this.getIgnoredColumnPatterns() + ")";
    }
}

