/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.mapper.template.delete.impl;

import app.myoss.cloud.mybatis.mapper.template.AbstractMapperTemplate;
import app.myoss.cloud.mybatis.table.TableColumnInfo;
import app.myoss.cloud.mybatis.table.TableInfo;
import app.myoss.cloud.mybatis.table.TableMetaObject;
import app.myoss.cloud.mybatis.table.annotation.FillRule;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

public class DeleteMapperTemplate
extends AbstractMapperTemplate {
    public String deleteByPrimaryKey(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        Configuration configuration = ms.getConfiguration();
        StringBuilder builder = new StringBuilder(128);
        if (tableInfo.isLogicDelete()) {
            metaObject.setValue("sqlCommandType", (Object)SqlCommandType.UPDATE);
            builder.append("UPDATE ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
            builder.append("<set>\n");
            for (TableColumnInfo columnInfo : tableInfo.getLogicDeleteColumns()) {
                builder.append("  ").append(columnInfo.getActualColumn());
                if (CharSequence.class.isAssignableFrom(columnInfo.getJavaType())) {
                    builder.append(" = '").append(columnInfo.getLogicDeleteValue()).append("'");
                } else {
                    builder.append(" = ").append(columnInfo.getLogicDeleteValue());
                }
                builder.append(",\n");
            }
            builder.append("</set>\n");
        } else {
            builder.append("DELETE FROM ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
        }
        builder.append((CharSequence)tableInfo.getWherePrimaryKeySql());
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }

    public String deleteWithPrimaryKey(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        Configuration configuration = ms.getConfiguration();
        StringBuilder builder = new StringBuilder(128);
        this.buildDeleteEntitySql(tableInfo, metaObject, builder);
        builder.append((CharSequence)tableInfo.getWherePrimaryKeySql());
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }

    private void buildDeleteEntitySql(TableInfo tableInfo, MetaObject metaObject, StringBuilder builder) {
        if (tableInfo.isLogicDelete()) {
            metaObject.setValue("sqlCommandType", (Object)SqlCommandType.UPDATE);
            builder.append("UPDATE ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
            builder.append("<set>\n");
            for (TableColumnInfo columnInfo : tableInfo.getColumns()) {
                boolean logicDelete = columnInfo.isLogicDelete();
                boolean fillUpdate = columnInfo.haveFillRule(FillRule.UPDATE);
                if (!logicDelete && !fillUpdate) continue;
                builder.append("  ").append(columnInfo.getActualColumn());
                if (logicDelete) {
                    if (CharSequence.class.isAssignableFrom(columnInfo.getJavaType())) {
                        builder.append(" = '").append(columnInfo.getLogicDeleteValue()).append("'");
                    } else {
                        builder.append(" = ").append(columnInfo.getLogicDeleteValue());
                    }
                } else {
                    builder.append(" = #{").append(columnInfo.getProperty());
                    if (columnInfo.getJdbcType() != null) {
                        builder.append(",jdbcType=BIGINT");
                    }
                    builder.append("}");
                }
                builder.append(",\n");
            }
            builder.append("</set>\n");
        } else {
            builder.append("DELETE FROM ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
        }
    }

    public String deleteByCondition(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        Configuration configuration = ms.getConfiguration();
        StringBuilder builder = new StringBuilder(2048);
        this.buildDeleteEntitySql(tableInfo, metaObject, builder);
        builder.append((CharSequence)tableInfo.getWhereConditionSql());
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }

    public String deleteByConditionAndUpdate(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        Configuration configuration = ms.getConfiguration();
        StringBuilder builder = new StringBuilder(2048);
        builder.append("UPDATE ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
        builder.append("<set>\n");
        for (TableColumnInfo columnInfo : tableInfo.getColumns()) {
            boolean logicDelete = columnInfo.isLogicDelete();
            boolean fillUpdate = columnInfo.haveFillRule(FillRule.UPDATE);
            if (!logicDelete && !fillUpdate && columnInfo.isPrimaryKey()) continue;
            if (logicDelete) {
                builder.append("  ").append(columnInfo.getActualColumn());
                if (CharSequence.class.isAssignableFrom(columnInfo.getJavaType())) {
                    builder.append(" = '").append(columnInfo.getLogicDeleteValue()).append("'");
                } else {
                    builder.append(" = ").append(columnInfo.getLogicDeleteValue());
                }
                builder.append(",\n");
                continue;
            }
            if (!fillUpdate) {
                builder.append("  <if test=\"record.").append(columnInfo.getProperty()).append(" != null\">\n  ");
            }
            builder.append("  ").append(columnInfo.getActualColumn()).append(" = #{record.").append(columnInfo.getProperty());
            if (columnInfo.getJdbcType() != null) {
                builder.append(",jdbcType=BIGINT");
            }
            builder.append("},\n");
            if (fillUpdate) continue;
            builder.append("  </if>\n");
        }
        builder.append("</set>\n");
        builder.append((CharSequence)tableInfo.getWhereConditionWithParameterSql());
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }
}

