/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.mapper.template.update.impl;

import app.myoss.cloud.mybatis.mapper.template.AbstractMapperTemplate;
import app.myoss.cloud.mybatis.table.TableColumnInfo;
import app.myoss.cloud.mybatis.table.TableInfo;
import app.myoss.cloud.mybatis.table.TableMetaObject;
import app.myoss.cloud.mybatis.table.annotation.FillRule;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

public class UpdateMapperTemplate
extends AbstractMapperTemplate {
    public String updateByPrimaryKey(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        Configuration configuration = ms.getConfiguration();
        StringBuilder builder = new StringBuilder(2048);
        builder.append("UPDATE ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
        builder.append("<set>\n");
        for (TableColumnInfo columnInfo : tableInfo.getColumns()) {
            if (!columnInfo.isUpdatable() || columnInfo.isPrimaryKey() || columnInfo.isLogicDelete()) continue;
            boolean fillUpdate = columnInfo.haveFillRule(FillRule.UPDATE);
            if (!fillUpdate) {
                builder.append("  <if test=\"").append(columnInfo.getProperty()).append(" != null\">\n");
            }
            builder.append("    ").append(columnInfo.getActualColumn()).append(" = #{").append(columnInfo.getProperty());
            if (columnInfo.getJdbcType() != null) {
                builder.append(",jdbcType=BIGINT");
            }
            builder.append("},\n");
            if (fillUpdate) continue;
            builder.append("  </if>\n");
        }
        builder.append("</set>\n");
        builder.append((CharSequence)tableInfo.getWherePrimaryKeySql());
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }

    public String updateByPrimaryKeyAllColumn(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        Configuration configuration = ms.getConfiguration();
        StringBuilder builder = new StringBuilder(1024);
        builder.append("UPDATE ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
        builder.append("<set>\n");
        for (TableColumnInfo columnInfo : tableInfo.getColumns()) {
            if (!columnInfo.isUpdatable() || columnInfo.isPrimaryKey() || columnInfo.isLogicDelete()) continue;
            builder.append("  ").append(columnInfo.getActualColumn()).append(" = #{").append(columnInfo.getProperty());
            if (columnInfo.getJdbcType() != null) {
                builder.append(",jdbcType=BIGINT");
            }
            builder.append("},\n");
        }
        builder.append("</set>\n");
        builder.append((CharSequence)tableInfo.getWherePrimaryKeySql());
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }

    public String updateByCondition(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        Configuration configuration = ms.getConfiguration();
        StringBuilder builder = new StringBuilder(4096);
        builder.append("UPDATE ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
        builder.append("<set>\n");
        for (TableColumnInfo columnInfo : tableInfo.getColumns()) {
            if (!columnInfo.isUpdatable() || columnInfo.isPrimaryKey() || columnInfo.isLogicDelete()) continue;
            boolean fillUpdate = columnInfo.haveFillRule(FillRule.UPDATE);
            if (!fillUpdate) {
                builder.append("  <if test=\"record.").append(columnInfo.getProperty()).append(" != null\">\n");
            }
            builder.append("    ").append(columnInfo.getActualColumn()).append(" = #{record.").append(columnInfo.getProperty());
            if (columnInfo.getJdbcType() != null) {
                builder.append(",jdbcType=BIGINT");
            }
            builder.append("},\n");
            if (fillUpdate) continue;
            builder.append("</if>\n");
        }
        builder.append("</set>\n");
        builder.append((CharSequence)tableInfo.getWhereConditionWithParameterSql());
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }

    public String updateUseMapByCondition(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        Configuration configuration = ms.getConfiguration();
        StringBuilder builder = new StringBuilder(2048);
        builder.append("UPDATE ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
        builder.append("<set>\n");
        builder.append("  <foreach collection=\"record.keys\" item=\"k\" separator=\",\">\n");
        builder.append("    ${k}").append(" = #{record[${k}]}\n");
        builder.append("  </foreach>\n");
        builder.append("</set>\n");
        builder.append((CharSequence)tableInfo.getWhereConditionWithParameterSql());
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }
}

