/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.sequence;

import java.util.concurrent.atomic.AtomicLong;

public class SequenceRange {
    private final long min;
    private final long max;
    private final AtomicLong value;
    private volatile boolean over = false;

    public SequenceRange(long min, long max) {
        this.min = min;
        this.max = max;
        this.value = new AtomicLong(min);
    }

    public long getBatch(int size) {
        long currentValue = this.value.getAndAdd(size) + (long)size - 1L;
        if (currentValue > this.max) {
            this.over = true;
            return -1L;
        }
        return currentValue;
    }

    public long getAndIncrement() {
        long currentValue = this.value.getAndIncrement();
        if (currentValue > this.max) {
            this.over = true;
            return -1L;
        }
        return currentValue;
    }

    public String toString() {
        return "max: " + this.max + ", min: " + this.min + ", value: " + this.value;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public boolean isOver() {
        return this.over;
    }
}

