/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.table;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.core.utils.NameStyle;
import app.myoss.cloud.mybatis.table.Sequence;
import app.myoss.cloud.mybatis.table.TableColumnInfo;
import app.myoss.cloud.mybatis.table.TableConfig;
import app.myoss.cloud.mybatis.table.TableInfo;
import app.myoss.cloud.mybatis.table.TableSequence;
import app.myoss.cloud.mybatis.table.annotation.Column;
import app.myoss.cloud.mybatis.table.annotation.FillRule;
import app.myoss.cloud.mybatis.table.annotation.GenerationType;
import app.myoss.cloud.mybatis.table.annotation.SelectKey;
import app.myoss.cloud.mybatis.table.annotation.SequenceGenerator;
import app.myoss.cloud.mybatis.table.annotation.SequenceKey;
import app.myoss.cloud.mybatis.table.annotation.Table;
import app.myoss.cloud.mybatis.type.UnsupportedTypeHandler;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.springframework.util.ClassUtils;

public class TableMetaObject {
    private static final Map<Class<?>, TableInfo> ENTITY_TABLE_MAP = new ConcurrentHashMap();
    private static final Map<String, Sequence> SEQUENCE_BEAN_MAP = new ConcurrentHashMap<String, Sequence>();
    private static final Class<? extends Annotation> PERSISTENCE_ID_CLASS = TableMetaObject.resolveAnnotationClassName("javax.persistence.Id");

    public static Class<? extends Annotation> resolveAnnotationClassName(String className) {
        ClassLoader classLoader = TableMetaObject.class.getClassLoader();
        if (ClassUtils.isPresent((String)className, (ClassLoader)classLoader)) {
            return ClassUtils.resolveClassName((String)className, (ClassLoader)classLoader);
        }
        return null;
    }

    public static void addSequenceBean(String sequenceBeanName, Sequence sequence) {
        if (SEQUENCE_BEAN_MAP.containsKey(sequenceBeanName)) {
            throw new IllegalArgumentException("already contains value for " + sequenceBeanName + ", sequence: " + sequence);
        }
        SEQUENCE_BEAN_MAP.putIfAbsent(sequenceBeanName, sequence);
    }

    public static Sequence getSequenceBean(String sequenceBeanName) {
        return SEQUENCE_BEAN_MAP.get(sequenceBeanName);
    }

    public static Map<String, Sequence> getSequenceBeanMap() {
        return SEQUENCE_BEAN_MAP;
    }

    public static Map<Class<?>, TableInfo> getTableInfoMap() {
        return ENTITY_TABLE_MAP;
    }

    public static TableInfo getTableInfo(Class<?> entityClass) {
        return ENTITY_TABLE_MAP.get(entityClass);
    }

    public static Class<?> getEntityClassByMapperInterface(Class<?> mapperInterfaceClass) {
        Type[] types;
        for (Type type : types = mapperInterfaceClass.getGenericInterfaces()) {
            Type[] actualTypeArguments;
            if (!(type instanceof ParameterizedType) || (actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()).length == 0) continue;
            return (Class)actualTypeArguments[0];
        }
        return null;
    }

    public static TableInfo getTableInfoByMapperInterface(Class<?> mapperInterface, TableConfig config, Configuration configuration) {
        Class<?> entityClass = TableMetaObject.getEntityClassByMapperInterface(mapperInterface);
        TableInfo tableInfo = TableMetaObject.getTableInfo(entityClass, config, configuration);
        tableInfo.addMapperInterfaceClass(mapperInterface);
        return tableInfo;
    }

    public static TableInfo getTableInfo(Class<?> entityClass, TableConfig config, Configuration configuration) {
        TableInfo tableInfo = ENTITY_TABLE_MAP.get(entityClass);
        if (tableInfo != null) {
            return tableInfo;
        }
        NameStyle tableNameStyle = config.getTableNameStyle();
        tableInfo = new TableInfo();
        tableInfo.setCatalog(config.getCatalog());
        tableInfo.setSchema(config.getSchema());
        if (entityClass.isAnnotationPresent(Table.class)) {
            String name;
            Table table = entityClass.getAnnotation(Table.class);
            String catalog = (String)StringUtils.defaultIfBlank((CharSequence)table.catalog(), (CharSequence)config.getCatalog());
            String schema = (String)StringUtils.defaultIfBlank((CharSequence)table.schema(), (CharSequence)config.getSchema());
            tableInfo.setCatalog(catalog);
            tableInfo.setSchema(schema);
            if (StringUtils.isNotBlank((CharSequence)table.name())) {
                name = config.getTableNamePrefix() + table.name() + config.getTableNameSuffix();
                tableInfo.setTableName(name);
            }
            if (StringUtils.isNotBlank((CharSequence)table.escapedName())) {
                name = config.getTableNamePrefix() + table.escapedName() + config.getTableNameSuffix();
                tableInfo.setEscapedTableName(name);
            }
            tableNameStyle = table.nameStyle();
        }
        if (StringUtils.isBlank((CharSequence)tableInfo.getTableName())) {
            String name = tableNameStyle.transform(entityClass.getSimpleName());
            String tableName = config.getTableNamePrefix() + name + config.getTableNameSuffix();
            tableInfo.setTableName(tableName);
        }
        tableInfo.setEntityClass(entityClass);
        TableMetaObject.initTableSequence(entityClass.getAnnotation(SequenceGenerator.class), tableInfo, null);
        TableSequence tableSequence = tableInfo.getTableSequence();
        Object[] keyProperties = tableSequence != null ? tableSequence.getKeyProperties() : null;
        String[] keyColumns = new String[keyProperties != null ? keyProperties.length : 0];
        Class[] resultTypes = new Class[keyProperties != null ? keyProperties.length : 0];
        NameStyle columnNameStyle = config.getColumnNameStyle();
        LinkedHashSet<TableColumnInfo> columns = new LinkedHashSet<TableColumnInfo>();
        LinkedHashSet<TableColumnInfo> pkColumns = new LinkedHashSet<TableColumnInfo>();
        LinkedHashSet<TableColumnInfo> logicDeleteColumns = new LinkedHashSet<TableColumnInfo>();
        Map<String, PropertyDescriptor> propertyDescriptorMap = TableMetaObject.getPropertyDescriptorMap(entityClass);
        List<Field> fields = TableMetaObject.getFieldList(entityClass);
        for (Field field : fields) {
            int indexOf;
            String name = field.getName();
            TableColumnInfo columnInfo = new TableColumnInfo();
            columnInfo.setTableInfo(tableInfo);
            columnInfo.setProperty(name);
            PropertyDescriptor propertyDescriptor = propertyDescriptorMap.get(name);
            if (propertyDescriptor == null) {
                String pascalName = NameStyle.PASCAL_CASE.transform(name);
                propertyDescriptor = propertyDescriptorMap.get(pascalName);
            }
            columnInfo.setJavaType(propertyDescriptor.getPropertyType());
            columnInfo.setPropertyDescriptor(propertyDescriptor);
            Column column = field.getAnnotation(Column.class);
            if (column != null) {
                if (column.isTransient()) continue;
                if (StringUtils.isNotBlank((CharSequence)column.name())) {
                    columnInfo.setColumn(column.name());
                }
                if (StringUtils.isNotBlank((CharSequence)column.escapedName())) {
                    columnInfo.setEscapedColumn(column.escapedName());
                }
                if (column.primaryKey()) {
                    columnInfo.setPrimaryKey(true);
                }
                if (column.typeHandler() != UnsupportedTypeHandler.class) {
                    columnInfo.setTypeHandler(column.typeHandler());
                }
                columnInfo.setInsertable(column.insertable());
                columnInfo.setUpdatable(column.updatable());
                columnInfo.setSelectable(column.selectable());
                Map<FillRule, String> fillRules = Stream.of(column.fillRule()).filter(s -> !FillRule.NONE.equals(s)).collect(Collectors.toMap(Function.identity(), FillRule::getValue));
                columnInfo.setFillRules(fillRules);
            }
            if (StringUtils.isBlank((CharSequence)columnInfo.getColumn())) {
                columnInfo.setColumn(columnNameStyle.transform(name));
            }
            TableMetaObject.initLogicDelete(config, tableInfo, columnInfo, column, logicDeleteColumns);
            if (!columnInfo.isPrimaryKey() && PERSISTENCE_ID_CLASS != null && field.isAnnotationPresent(PERSISTENCE_ID_CLASS)) {
                columnInfo.setPrimaryKey(true);
            }
            if (columnInfo.isPrimaryKey()) {
                pkColumns.add(columnInfo);
            }
            if ((indexOf = ArrayUtils.indexOf((Object[])keyProperties, (Object)columnInfo.getProperty())) > -1) {
                keyColumns[indexOf] = columnInfo.getColumn();
                resultTypes[indexOf] = columnInfo.getJavaType();
            }
            TableMetaObject.initTableSequence(field.getAnnotation(SequenceGenerator.class), tableInfo, columnInfo);
            columns.add(columnInfo);
        }
        tableInfo.setColumns(columns);
        tableInfo.setPrimaryKeyColumns(pkColumns);
        tableInfo.setLogicDeleteColumns(logicDeleteColumns);
        if (keyProperties != null && keyColumns.length > 0 && ArrayUtils.isEmpty((Object[])tableInfo.getTableSequence().getKeyColumns())) {
            tableInfo.getTableSequence().setKeyColumns(keyColumns);
        }
        if (keyProperties != null && resultTypes.length > 0 && ArrayUtils.isEmpty((Object[])tableInfo.getTableSequence().getResultType())) {
            tableInfo.getTableSequence().setResultType(resultTypes);
        }
        tableInfo.setBaseResultMap(TableMetaObject.builderBaseResultMap(tableInfo, configuration));
        tableInfo.setSelectAllColumnsSql(TableMetaObject.builderSelectAllColumns(tableInfo));
        tableInfo.setWherePrimaryKeySql(TableMetaObject.builderWherePrimaryKeySql(tableInfo, false));
        tableInfo.setWherePrimaryKeyIncludeLogicDeleteSql(TableMetaObject.builderWherePrimaryKeySql(tableInfo, true));
        tableInfo.setWhereConditionSql(TableMetaObject.builderWhereConditionSql(tableInfo, false));
        tableInfo.setWhereConditionIncludeLogicDeleteSql(TableMetaObject.builderWhereConditionSql(tableInfo, true));
        tableInfo.setWhereConditionWithParameterSql(TableMetaObject.builderWhereConditionWithParameterSql(tableInfo, false, "condition"));
        tableInfo.setWhereConditionWithParameterIncludeLogicDeleteSql(TableMetaObject.builderWhereConditionWithParameterSql(tableInfo, true, "condition"));
        tableInfo.setTableConfig(config);
        tableInfo.setConfiguration(configuration);
        ENTITY_TABLE_MAP.put(entityClass, tableInfo);
        return tableInfo;
    }

    private static void initTableSequence(SequenceGenerator sequenceGenerator, TableInfo tableInfo, TableColumnInfo columnInfo) {
        if (sequenceGenerator == null) {
            return;
        }
        if (tableInfo.getTableSequence() != null) {
            throw new BindingException("more than one sequence field: [" + tableInfo.getTableSequence() + ", " + columnInfo + "]");
        }
        GenerationType strategy = sequenceGenerator.strategy();
        TableSequence tableSequence = new TableSequence();
        if (strategy == GenerationType.USE_GENERATED_KEYS) {
            if (columnInfo != null) {
                columnInfo.setAutoIncrement(true);
            }
        } else if (strategy == GenerationType.SELECT_KEY) {
            SelectKey selectKey = sequenceGenerator.selectKey();
            tableSequence.setKeyProperties(selectKey.keyProperty());
            tableSequence.setKeyColumns(selectKey.keyColumn());
            if (selectKey.resultType() != Class.class) {
                tableSequence.setResultType(new Class[]{selectKey.resultType()});
            }
            tableSequence.setSql(selectKey.sql());
            tableSequence.setStatementType(selectKey.statementType());
            tableSequence.setOrder(selectKey.order());
            if (columnInfo != null) {
                if (ArrayUtils.isEmpty((Object[])tableSequence.getKeyProperties())) {
                    tableSequence.setKeyProperties(new String[]{columnInfo.getProperty()});
                }
                if (ArrayUtils.isEmpty((Object[])tableSequence.getKeyColumns())) {
                    tableSequence.setKeyColumns(new String[]{columnInfo.getColumn()});
                }
                if (ArrayUtils.isEmpty((Object[])tableSequence.getResultType())) {
                    tableSequence.setResultType(new Class[]{columnInfo.getJavaType()});
                }
            }
        } else if (strategy == GenerationType.SEQUENCE_KEY) {
            SequenceKey sequenceKey = sequenceGenerator.sequenceKey();
            tableSequence.setKeyProperties(sequenceKey.keyProperty());
            tableSequence.setKeyColumns(sequenceKey.keyColumn());
            tableSequence.setSequenceClass(sequenceKey.sequenceClass());
            tableSequence.setSequenceBeanName(sequenceKey.sequenceBeanName());
            tableSequence.setSequenceName(sequenceKey.sequenceName());
            tableSequence.setOrder(sequenceKey.order());
            if (columnInfo != null) {
                if (ArrayUtils.isEmpty((Object[])tableSequence.getKeyProperties())) {
                    tableSequence.setKeyProperties(new String[]{columnInfo.getProperty()});
                }
                if (ArrayUtils.isEmpty((Object[])tableSequence.getKeyColumns())) {
                    tableSequence.setKeyColumns(new String[]{columnInfo.getColumn()});
                }
            }
        } else {
            throw new UnsupportedOperationException("keyGenerator strategy " + strategy.getType() + " unsupported");
        }
        if (strategy != GenerationType.USE_GENERATED_KEYS && ArrayUtils.isEmpty((Object[])tableSequence.getKeyProperties())) {
            throw new BindingException("keyProperty value is blank: " + sequenceGenerator);
        }
        tableSequence.setStrategy(strategy);
        tableInfo.setTableSequence(tableSequence);
    }

    private static void initLogicDelete(TableConfig config, TableInfo tableInfo, TableColumnInfo columnInfo, Column column, Set<TableColumnInfo> logicDeleteColumns) {
        boolean isLogicDelete = false;
        String deleteValue = null;
        String unDeleteValue = null;
        if (column != null && column.logicDelete()) {
            isLogicDelete = true;
            unDeleteValue = (String)StringUtils.defaultIfBlank((CharSequence)column.logicUnDeleteValue(), (CharSequence)config.getLogicUnDeleteValue());
            deleteValue = (String)StringUtils.defaultIfBlank((CharSequence)column.logicDeleteValue(), (CharSequence)config.getLogicDeleteValue());
        } else if (config.isLogicDelete() && columnInfo.getColumn().equals(config.getLogicDeleteColumnName())) {
            isLogicDelete = true;
            deleteValue = config.getLogicDeleteValue();
            unDeleteValue = config.getLogicUnDeleteValue();
        }
        if (isLogicDelete) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{deleteValue, unDeleteValue})) {
                throw new BindingException("logicDeleteValue or logicUnDeleteValue is blank, [logicDeleteValue=" + deleteValue + ", logicUnDeleteValue=" + unDeleteValue + "]");
            }
            columnInfo.setLogicDelete(true);
            columnInfo.setLogicDeleteValue(deleteValue);
            columnInfo.setLogicUnDeleteValue(unDeleteValue);
            tableInfo.setLogicDelete(true);
            logicDeleteColumns.add(columnInfo);
        }
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        HashMap<String, Boolean> allFiledName = new HashMap<String, Boolean>();
        boolean isSupper = false;
        for (Class<?> currentClass = Objects.requireNonNull(clazz); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            int idx = 0;
            for (Field field : declaredFields) {
                String name = field.getName();
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || isSupper && allFiledName.containsKey(name)) continue;
                allFiledName.put(name, true);
                if (isSupper) {
                    allFields.add(idx++, field);
                    continue;
                }
                allFields.add(field);
            }
            isSupper = true;
        }
        return allFields;
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BizRuntimeException((Throwable)e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        return Stream.of(descriptors).filter(s -> !"class".equals(s.getName())).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
    }

    public static String getTableName(TableInfo tableInfo) {
        return Stream.of(tableInfo.getCatalog(), tableInfo.getSchema(), tableInfo.getActualTableName()).filter(StringUtils::isNotBlank).collect(Collectors.joining("."));
    }

    public static ResultMap builderBaseResultMap(TableInfo tableInfo, Configuration configuration) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (TableColumnInfo item : tableInfo.getColumns()) {
            ResultMapping.Builder builder = new ResultMapping.Builder(configuration, item.getProperty(), item.getColumn(), item.getJavaType());
            if (item.getJdbcType() != null) {
                builder.jdbcType(item.getJdbcType());
            }
            if (item.getTypeHandler() != null) {
                try {
                    TypeHandler<?> typeHandler = item.getTypeHandler().newInstance();
                    builder.typeHandler(typeHandler);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new BizRuntimeException((Throwable)e);
                }
            }
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (item.isPrimaryKey()) {
                flags.add(ResultFlag.ID);
            }
            builder.flags(flags);
            resultMappings.add(builder.build());
        }
        ResultMap.Builder builder = new ResultMap.Builder(configuration, "BaseResultMap", tableInfo.getEntityClass(), resultMappings, Boolean.valueOf(true));
        return builder.build();
    }

    public static String builderSelectAllColumns(TableInfo tableInfo) {
        return tableInfo.getColumns().stream().filter(TableColumnInfo::isSelectable).map(TableColumnInfo::getActualColumn).collect(Collectors.joining(", "));
    }

    public static StringBuilder builderWhereConditionSql(TableInfo tableInfo, boolean includeLogicDelete) {
        StringBuilder sql = new StringBuilder(1024);
        sql.append("<where>\n");
        for (TableColumnInfo item : tableInfo.getColumns()) {
            if (!includeLogicDelete && item.isLogicDelete()) continue;
            sql.append("  <if test=\"").append(item.getProperty()).append(" != null\">\n");
            sql.append("    and ").append(item.getActualColumn()).append(" = #{").append(item.getProperty());
            if (item.getJdbcType() != null) {
                sql.append(",jdbcType=").append(item.getJdbcType().name());
            }
            sql.append("}\n");
            sql.append("  </if>\n");
        }
        if (!includeLogicDelete && tableInfo.isLogicDelete()) {
            for (TableColumnInfo item : tableInfo.getLogicDeleteColumns()) {
                sql.append("  and ").append(item.getActualColumn()).append(" = ");
                if (CharSequence.class.isAssignableFrom(item.getJavaType())) {
                    sql.append("'").append(item.getLogicUnDeleteValue()).append("'");
                } else {
                    sql.append(item.getLogicUnDeleteValue());
                }
                sql.append("\n");
            }
        }
        sql.append("</where>");
        return sql;
    }

    public static StringBuilder builderWhereConditionWithParameterSql(TableInfo tableInfo, boolean includeLogicDelete, String conditionPrefix) {
        String prefix = conditionPrefix + ".";
        StringBuilder sql = new StringBuilder(2048);
        sql.append("<where>\n");
        sql.append("  <if test=\"").append(conditionPrefix).append(" != null\">\n");
        for (TableColumnInfo item : tableInfo.getColumns()) {
            if (!includeLogicDelete && item.isLogicDelete()) continue;
            sql.append("    <if test=\"").append(prefix).append(item.getProperty()).append(" != null\">\n");
            sql.append("      and ").append(item.getActualColumn()).append(" = #{").append(prefix).append(item.getProperty());
            if (item.getJdbcType() != null) {
                sql.append(",jdbcType=").append(item.getJdbcType().name());
            }
            sql.append("}\n");
            sql.append("    </if>\n");
        }
        sql.append("  </if>\n");
        if (!includeLogicDelete && tableInfo.isLogicDelete()) {
            for (TableColumnInfo item : tableInfo.getLogicDeleteColumns()) {
                sql.append("  and ").append(item.getActualColumn()).append(" = ");
                if (CharSequence.class.isAssignableFrom(item.getJavaType())) {
                    sql.append("'").append(item.getLogicUnDeleteValue()).append("'");
                } else {
                    sql.append(item.getLogicUnDeleteValue());
                }
                sql.append("\n");
            }
        }
        sql.append("</where>");
        return sql;
    }

    public static StringBuilder builderWherePrimaryKeySql(TableInfo tableInfo, boolean includeLogicDelete) {
        StringBuilder sql = new StringBuilder(128);
        sql.append("<where>\n");
        for (TableColumnInfo columnInfo : tableInfo.getPrimaryKeyColumns()) {
            sql.append("  AND ").append(columnInfo.getActualColumn()).append(" = ");
            sql.append("#{").append(columnInfo.getProperty());
            if (columnInfo.getJdbcType() != null) {
                sql.append(",jdbcType=BIGINT");
            }
            sql.append("}\n");
        }
        if (!includeLogicDelete && tableInfo.isLogicDelete()) {
            for (TableColumnInfo item : tableInfo.getLogicDeleteColumns()) {
                sql.append("  AND ").append(item.getActualColumn()).append(" = ");
                if (CharSequence.class.isAssignableFrom(item.getJavaType())) {
                    sql.append("'").append(item.getLogicUnDeleteValue()).append("'");
                } else {
                    sql.append(item.getLogicUnDeleteValue());
                }
                sql.append("\n");
            }
        }
        sql.append("</where>");
        return sql;
    }
}

