/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.sequence.utils;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.mybatis.table.TableSequence;
import app.myoss.cloud.sequence.Sequence;
import app.myoss.cloud.sequence.SequenceRepository;
import app.myoss.cloud.sequence.impl.DefaultSequenceImpl;
import app.myoss.cloud.sequence.impl.RdsSequenceRepository;
import app.myoss.cloud.sequence.spring.boot.autoconfigure.RdsSequenceProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public class DefaultSequenceUtils {
    private static final Logger log = LoggerFactory.getLogger(DefaultSequenceUtils.class);

    public static RdsSequenceRepository buildRdsSequenceRepository(ApplicationContext applicationContext, RdsSequenceProperties sequenceConfig, boolean init) {
        Map<String, DataSource> dataSourceMap;
        RdsSequenceRepository repository = new RdsSequenceRepository();
        repository.setDbGroupKeys(sequenceConfig.getDbGroupKeys());
        repository.setDataSourceMap(sequenceConfig.getDataSourceMap());
        if (applicationContext != null && !CollectionUtils.isEmpty(sequenceConfig.getDataSourceBeanName()) && !CollectionUtils.isEmpty(dataSourceMap = sequenceConfig.getDataSourceBeanName().stream().collect(Collectors.toMap(Function.identity(), s -> (DataSource)applicationContext.getBean(s, DataSource.class))))) {
            if (CollectionUtils.isEmpty(repository.getDataSourceMap())) {
                repository.setDataSourceMap(dataSourceMap);
            } else {
                repository.getDataSourceMap().putAll(dataSourceMap);
            }
        }
        repository.setDataSourceCount(sequenceConfig.getDataSourceCount());
        repository.setInnerStep(sequenceConfig.getInnerStep());
        repository.setRetryTimes(sequenceConfig.getRetryTimes());
        repository.setTableName(sequenceConfig.getTableName());
        repository.setNameColumnName(sequenceConfig.getNameColumnName());
        repository.setValueColumnName(sequenceConfig.getValueColumnName());
        repository.setGmtCreatedColumnName(sequenceConfig.getGmtCreatedColumnName());
        repository.setGmtModifiedColumnName(sequenceConfig.getGmtModifiedColumnName());
        repository.setAdjust(sequenceConfig.isAdjust());
        if (init) {
            repository.init();
        }
        return repository;
    }

    public static void initDefaultSequence(Collection<app.myoss.cloud.mybatis.table.Sequence> sequences, SequenceRepository sequenceRepository, ApplicationContext applicationContext) {
        HashMap<String, Sequence> map = new HashMap<String, Sequence>();
        for (app.myoss.cloud.mybatis.table.Sequence itemValue : sequences) {
            Sequence sequence;
            Class sequenceDelegateClass = itemValue.getSequenceDelegateClass();
            if (sequenceDelegateClass != Sequence.class || itemValue.getSequenceDelegate() != null) continue;
            TableSequence tableSequence = itemValue.getTableInfo().getTableSequence();
            String sequenceName = tableSequence.getSequenceName();
            if (StringUtils.isBlank((CharSequence)sequenceName)) {
                throw new NullPointerException("sequenceName is null, tableInfo: " + itemValue.getTableInfo());
            }
            if (map.containsKey(sequenceName)) {
                sequence = (Sequence)map.get(sequenceName);
                itemValue.setSequenceDelegate(sequence);
                continue;
            }
            sequence = DefaultSequenceUtils.initDefaultSequence(applicationContext, sequenceName, null, sequenceRepository);
            if (sequence == null) {
                throw new BizRuntimeException("create DefaultSequenceImpl failed, sequenceName = " + sequenceName + ", tableName = " + itemValue.getTableInfo().getTableName());
            }
            itemValue.setSequenceDelegate(sequence);
            map.put(sequenceName, sequence);
        }
    }

    public static DefaultSequenceImpl initDefaultSequence(ApplicationContext applicationContext, String sequenceName, String sequenceRepositoryBeanName, SequenceRepository sequenceRepository) {
        if (applicationContext.containsBean(sequenceName)) {
            return (DefaultSequenceImpl)applicationContext.getBean(sequenceName, DefaultSequenceImpl.class);
        }
        if (sequenceRepository != null || StringUtils.isNotBlank((CharSequence)sequenceRepositoryBeanName)) {
            try {
                DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
                BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultSequenceImpl.class);
                beanDefinitionBuilder.addPropertyValue("name", (Object)sequenceName);
                if (sequenceRepository != null) {
                    beanDefinitionBuilder.addPropertyValue("sequenceRepository", (Object)sequenceRepository);
                } else {
                    beanDefinitionBuilder.addPropertyValue("sequenceRepository", (Object)new RuntimeBeanReference(sequenceRepositoryBeanName));
                }
                AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
                beanDefinition.setInitMethodName("init");
                log.info("register DefaultSequenceImpl: {}", (Object)sequenceName);
                beanFactory.registerBeanDefinition(sequenceName, (BeanDefinition)beanDefinition);
                return (DefaultSequenceImpl)applicationContext.getBean(sequenceName, DefaultSequenceImpl.class);
            }
            catch (Exception ex) {
                throw new BizRuntimeException("create DefaultSequenceImpl failed, sequenceName = " + sequenceName, (Throwable)ex);
            }
        }
        return null;
    }
}

