/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.executor.keygen;

import app.myoss.cloud.mybatis.table.Sequence;
import app.myoss.cloud.mybatis.table.TableInfo;
import app.myoss.cloud.mybatis.table.TableMetaObject;
import app.myoss.cloud.mybatis.table.TableSequence;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.springframework.util.CollectionUtils;

public class SequenceKeyGenerator
implements KeyGenerator {
    public static final String SEQUENCE_KEY_SUFFIX = "!sequenceKey";
    private String[] keyProperties;
    private String[] keyColumns;
    private boolean executeBefore;
    private Sequence sequence;

    public SequenceKeyGenerator(TableInfo tableInfo, String sqlId, boolean executeBefore) {
        TableSequence tableSequence = tableInfo.getTableSequence();
        this.keyProperties = tableSequence.getKeyProperties();
        this.keyColumns = tableSequence.getKeyColumns();
        this.executeBefore = executeBefore;
        String sequenceBeanName = tableSequence.getSequenceBeanName();
        if (StringUtils.isNotBlank((CharSequence)sequenceBeanName)) {
            this.sequence = TableMetaObject.getSequenceBean(sequenceBeanName);
            if (this.sequence == null) {
                throw new BindingException("no instance of [" + sequenceBeanName + "] in TableMetaObject, please check!");
            }
        } else {
            try {
                this.sequence = tableSequence.getSequenceClass().newInstance();
                String name = StringUtils.defaultString((String)tableSequence.getSequenceName(), (String)SEQUENCE_KEY_SUFFIX);
                TableMetaObject.addSequenceBean(sqlId + "." + name, this.sequence);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new BindingException("new instance of [" + tableSequence.getSequenceClass() + "] failed", (Throwable)e);
            }
        }
        this.sequence.setTableInfo(tableInfo);
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (this.executeBefore) {
            this.processGeneratedKeys(ms, parameter);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        if (!this.executeBefore) {
            this.processGeneratedKeys(ms, parameter);
        }
    }

    private void processGeneratedKeys(MappedStatement ms, Object parameter) {
        try {
            if (parameter != null && this.keyProperties != null && this.keyProperties.length > 0) {
                if (this.keyColumns != null && this.keyColumns.length != this.keyProperties.length) {
                    throw new ExecutorException("If SelectKey has key columns, the number must match the number of key properties.");
                }
                Configuration configuration = ms.getConfiguration();
                MetaObject metaParam = configuration.newMetaObject(parameter);
                ArrayList<String> keys = new ArrayList<String>(this.keyProperties.length);
                ArrayList<String> columns = new ArrayList<String>(this.keyProperties.length);
                for (int i = 0; i < this.keyProperties.length; ++i) {
                    String keyProperty = this.keyProperties[i];
                    if (metaParam.hasGetter(keyProperty) && this.checkValueIsNotNull(metaParam, keyProperty)) continue;
                    keys.add(keyProperty);
                    if (this.keyColumns == null) continue;
                    columns.add(this.keyColumns[i]);
                }
                if (keys.size() == 0) {
                    return;
                }
                Object value = this.sequence.nextValue(parameter);
                MetaObject metaResult = configuration.newMetaObject(value);
                if (keys.size() == 1) {
                    String keyProperty = (String)keys.get(0);
                    if (metaResult.hasGetter(keyProperty)) {
                        this.setValue(metaParam, keyProperty, metaResult.getValue(keyProperty));
                    } else {
                        this.setValue(metaParam, keyProperty, value);
                    }
                } else {
                    this.handleMultipleProperties(keys, columns, metaParam, metaResult);
                }
            }
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException("Error selecting key or setting result to parameter object. Cause: " + e, (Throwable)e);
        }
    }

    private void handleMultipleProperties(List<String> keyProperties, List<String> columns, MetaObject metaParam, MetaObject metaResult) {
        if (CollectionUtils.isEmpty(columns)) {
            for (String keyProperty : keyProperties) {
                this.setValue(metaParam, keyProperty, metaResult.getValue(keyProperty));
            }
        } else {
            if (keyProperties.size() != columns.size()) {
                throw new ExecutorException("If SelectKey has key columns, the number must match the number of key properties.");
            }
            for (int i = 0; i < keyProperties.size(); ++i) {
                this.setValue(metaParam, keyProperties.get(i), metaResult.getValue(columns.get(i)));
            }
        }
    }

    private void setValue(MetaObject metaParam, String property, Object value) {
        if (!metaParam.hasSetter(property)) {
            throw new ExecutorException("No setter found for the keyProperty '" + property + "' in " + metaParam.getOriginalObject().getClass().getName() + ".");
        }
        metaParam.setValue(property, value);
    }

    private boolean checkValueIsNotNull(MetaObject metaParam, String keyProperty) {
        Object value = metaParam.getValue(keyProperty);
        if (value instanceof CharSequence && StringUtils.isBlank((CharSequence)((CharSequence)value))) {
            return true;
        }
        return value != null;
    }
}

