/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.plugin.impl;

import app.myoss.cloud.mybatis.plugin.ParameterHandlerCustomizer;
import app.myoss.cloud.mybatis.repository.entity.AuditIdEntity;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;

public class DefaultParameterHandlerCustomizer
implements ParameterHandlerCustomizer {
    public static final String COLLECTION = "collection";
    public static final String RECORD = "record";

    public static void setAuditInfo(Object o, boolean isInsert) {
        if (o instanceof AuditIdEntity) {
            AuditIdEntity entity = (AuditIdEntity)o;
            if (isInsert) {
                if (StringUtils.isBlank((CharSequence)entity.getIsDeleted())) {
                    entity.setIsDeleted("N");
                }
                if (StringUtils.isBlank((CharSequence)entity.getCreator())) {
                    entity.setCreator("system");
                }
                if (entity.getGmtCreated() == null) {
                    entity.setGmtCreated(new Date());
                }
            }
            if (StringUtils.isBlank((CharSequence)entity.getModifier())) {
                entity.setModifier("system");
            }
            entity.setGmtModified(new Date());
        }
    }

    public static void setCommonParameter(Object parameterObject, boolean isInsert) {
        if (parameterObject instanceof AuditIdEntity) {
            AuditIdEntity entity = (AuditIdEntity)parameterObject;
            DefaultParameterHandlerCustomizer.setAuditInfo(entity, isInsert);
        } else if (parameterObject instanceof Map) {
            Map map = (Map)parameterObject;
            if (map.containsKey(COLLECTION)) {
                Object collection = map.get(COLLECTION);
                if (collection instanceof Collection) {
                    Collection value = (Collection)collection;
                    for (Object entity : value) {
                        DefaultParameterHandlerCustomizer.setAuditInfo(entity, isInsert);
                    }
                }
            } else if (map.containsKey(RECORD)) {
                Object record = map.get(RECORD);
                DefaultParameterHandlerCustomizer.setAuditInfo(record, isInsert);
            }
        }
    }

    @Override
    public void handlerInsert(MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) {
        DefaultParameterHandlerCustomizer.setCommonParameter(parameterObject, true);
    }

    @Override
    public void handlerUpdate(MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) {
        DefaultParameterHandlerCustomizer.setCommonParameter(parameterObject, false);
    }

    @Override
    public void handlerDelete(MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) {
        DefaultParameterHandlerCustomizer.setCommonParameter(parameterObject, false);
    }
}

