/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.repository.utils;

import app.myoss.cloud.core.lang.bean.BeanUtil;
import app.myoss.cloud.core.lang.dto.Order;
import app.myoss.cloud.core.lang.dto.Sort;
import app.myoss.cloud.mybatis.table.TableColumnInfo;
import app.myoss.cloud.mybatis.table.TableInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CrudServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(CrudServiceUtils.class);

    public static boolean checkPrimaryKeyIsNull(TableInfo tableInfo, Object record, boolean checkAll) {
        boolean isNull;
        boolean bl = isNull = record == null;
        if (!isNull) {
            int nullCount = 0;
            Set<TableColumnInfo> primaryKeyColumns = tableInfo.getPrimaryKeyColumns();
            for (TableColumnInfo columnInfo : primaryKeyColumns) {
                Object value = BeanUtil.methodInvoke((Method)columnInfo.getPropertyDescriptor().getReadMethod(), (Object)record, (Object[])new Object[0]);
                if (value == null) {
                    ++nullCount;
                } else if (value instanceof CharSequence && StringUtils.isBlank((CharSequence)((CharSequence)value))) {
                    ++nullCount;
                }
                if (nullCount <= 0 || checkAll) continue;
                isNull = true;
                break;
            }
            if (checkAll && nullCount > 0 && nullCount == primaryKeyColumns.size()) {
                isNull = true;
            }
        }
        return isNull;
    }

    public static Map<String, Object> convertToUpdateUseMap(Map<String, String> fieldColumns, Map<String, Object> record, Class<?> clazz) {
        HashMap<String, Object> updateMap = new HashMap<String, Object>(record.size());
        for (Map.Entry<String, Object> entry : record.entrySet()) {
            String key = entry.getKey();
            String columnName = fieldColumns.get(key);
            if (columnName != null) {
                updateMap.put(columnName, entry.getValue());
                continue;
            }
            log.error("[{}] ignored invalid filed: {}", clazz, (Object)key);
        }
        return updateMap;
    }

    public static List<Order> convertToOrders(Map<String, String> fieldColumns, Sort sort, Class<?> clazz) {
        if (sort == null || CollectionUtils.isEmpty((Collection)sort.getOrders())) {
            return null;
        }
        ArrayList<Order> orders = new ArrayList<Order>(sort.getOrders().size());
        for (Order item : sort.getOrders()) {
            String columnName = fieldColumns.get(item.getProperty());
            if (columnName != null) {
                Order order = new Order(item.getDirection(), columnName);
                orders.add(order);
                continue;
            }
            log.error("[{}] ignored invalid filed: {}", clazz, (Object)item.getProperty());
        }
        return orders;
    }
}

