/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.repository.v2.service.impl;

import app.myoss.cloud.core.lang.bean.BeanUtil;
import app.myoss.cloud.core.lang.concurrent.CallableFunc;
import app.myoss.cloud.core.lang.dto.Order;
import app.myoss.cloud.core.lang.dto.Sort;
import app.myoss.cloud.mybatis.mapper.template.CrudMapper;
import app.myoss.cloud.mybatis.repository.entity.LogicDeleteEntity;
import app.myoss.cloud.mybatis.repository.entity.PrimaryKeyEntity;
import app.myoss.cloud.mybatis.repository.utils.CrudServiceUtils;
import app.myoss.cloud.mybatis.repository.utils.DbUtils;
import app.myoss.cloud.mybatis.repository.v2.service.CrudService;
import app.myoss.cloud.mybatis.repository.v2.service.exception.BizServiceException;
import app.myoss.cloud.mybatis.table.TableColumnInfo;
import app.myoss.cloud.mybatis.table.TableInfo;
import app.myoss.cloud.mybatis.table.TableMetaObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class BaseCrudServiceImpl<M extends CrudMapper<T>, T>
implements CrudService<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseCrudServiceImpl.class);
    protected Class<?> mapperClass;
    protected Class<?> entityClass;
    protected TableInfo tableInfo;
    protected Map<String, String> fieldColumns;
    protected M crudMapper;

    public BaseCrudServiceImpl() {
        Class<?> clazz = this.getClass();
        Type genType = clazz.getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.mapperClass = (Class)params[0];
        this.entityClass = (Class)params[1];
    }

    @Autowired
    public void setCrudMapper(M crudMapper) {
        this.crudMapper = crudMapper;
        this.tableInfo = TableMetaObject.getTableInfo(this.entityClass);
        if (this.tableInfo != null) {
            this.fieldColumns = Collections.unmodifiableMap(this.tableInfo.getColumns().stream().collect(Collectors.toMap(TableColumnInfo::getProperty, TableColumnInfo::getActualColumn)));
        } else {
            log.error("[{}] getTableInfo failed in [{}]", this.entityClass, this.getClass());
        }
    }

    protected void checkNull4Create(T record, Object optionParam) {
        if (record == null) {
            throw new BizServiceException("valueIsBlank", "\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void checkPrimaryKeyIsNull(SqlCommandType sqlCommandType, Serializable id) {
        if (id == null) {
            throw new BizServiceException("valueIsBlank", "\u4e3b\u952e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected boolean checkPrimaryKeyIsNull(SqlCommandType sqlCommandType, Object record, boolean checkAll) {
        return CrudServiceUtils.checkPrimaryKeyIsNull(this.tableInfo, record, checkAll);
    }

    protected void checkPrimaryKeyIsNull(SqlCommandType sqlCommandType, Object record) {
        boolean isNull = this.checkPrimaryKeyIsNull(sqlCommandType, record, true);
        if (isNull) {
            throw new BizServiceException("valueIsBlank", "\u4e3b\u952e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void checkCommonQueryConditionIsAllNull(SqlCommandType sqlCommandType, T condition, Map<String, Object> extraCondition) {
        this.checkPrimaryKeyIsNull(sqlCommandType, condition);
    }

    protected boolean checkPageConditionIsAllNull(app.myoss.cloud.core.lang.dto.Page<T> condition, app.myoss.cloud.core.lang.dto.Page<T> result) {
        return result.isSuccess();
    }

    protected void validFieldValue(T record, Object optionParam) {
        if (record == null) {
            throw new BizServiceException("valueIsBlank", "\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void validFieldValue(Map<String, Object> record, Object optionParam) {
        if (record == null) {
            throw new BizServiceException("valueIsBlank", "\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected void createValidate(T record, Object optionParam) {
        this.checkNull4Create(record, optionParam);
        this.validFieldValue(record, optionParam);
    }

    protected Map<String, Object> convertToUpdateUseMap(Map<String, Object> record) {
        return CrudServiceUtils.convertToUpdateUseMap(this.fieldColumns, record, this.getClass());
    }

    protected List<Order> convertToOrders(Sort sort) {
        return CrudServiceUtils.convertToOrders(this.fieldColumns, sort, this.getClass());
    }

    protected List<T> findExistRecord4CheckRecord(T record) {
        return null;
    }

    protected void checkRecordIfExist4Create(T record) {
        List<T> exists = this.findExistRecord4CheckRecord(record);
        if (CollectionUtils.isEmpty(exists)) {
            return;
        }
        T item = exists.get(0);
        StringBuilder errorMsg = new StringBuilder();
        Iterator<TableColumnInfo> iterator = this.tableInfo.getPrimaryKeyColumns().iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            TableColumnInfo columnInfo = iterator.next();
            Object value = BeanUtil.methodInvoke((Method)columnInfo.getPropertyDescriptor().getReadMethod(), item, (Object[])new Object[0]);
            errorMsg.append(columnInfo.getProperty()).append("=").append(value);
            hasNext = iterator.hasNext();
            if (!hasNext) continue;
            errorMsg.append(", ");
        }
        if (errorMsg.length() > 0) {
            errorMsg.insert(0, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55\uff0c\u4e3b\u952e\u503c[").append("]");
            throw new BizServiceException("moreRecords", errorMsg.toString());
        }
        throw new BizServiceException("moreRecords", "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55");
    }

    protected void checkRecordIfExist4Update(T record) {
        Set<TableColumnInfo> primaryKeyColumns;
        if (record instanceof LogicDeleteEntity && StringUtils.equals((CharSequence)((LogicDeleteEntity)record).getIsDeleted(), (CharSequence)"Y")) {
            return;
        }
        List<T> exists = this.findExistRecord4CheckRecord(record);
        if (CollectionUtils.isEmpty(exists)) {
            return;
        }
        if (record instanceof PrimaryKeyEntity) {
            Object id = ((PrimaryKeyEntity)record).getPrimaryKey();
            for (T item : exists) {
                Object id1 = ((PrimaryKeyEntity)item).getPrimaryKey();
                if (id1.equals(id)) continue;
                throw new BizServiceException("moreRecords", "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55\uff0c\u4e3b\u952eid=" + id1);
            }
        }
        if (!CollectionUtils.isEmpty(primaryKeyColumns = this.tableInfo.getPrimaryKeyColumns())) {
            ArrayList<Object> sourceValues = new ArrayList<Object>(primaryKeyColumns.size());
            for (TableColumnInfo columnInfo : primaryKeyColumns) {
                Object value = BeanUtil.methodInvoke((Method)columnInfo.getPropertyDescriptor().getReadMethod(), record, (Object[])new Object[0]);
                sourceValues.add(value);
            }
            for (TableColumnInfo item : exists) {
                ArrayList<Object> itemValues = new ArrayList<Object>(primaryKeyColumns.size());
                for (TableColumnInfo columnInfo : primaryKeyColumns) {
                    Object value = BeanUtil.methodInvoke((Method)columnInfo.getPropertyDescriptor().getReadMethod(), (Object)item, (Object[])new Object[0]);
                    itemValues.add(value);
                }
                if (Objects.deepEquals(sourceValues, itemValues)) continue;
                StringBuilder errorMsg = new StringBuilder("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55\uff0c\u4e3b\u952e\u503c[");
                int idx = 0;
                for (TableColumnInfo columnInfo : primaryKeyColumns) {
                    Object value = itemValues.get(idx++);
                    errorMsg.append(columnInfo.getProperty()).append("=").append(value);
                    if (idx >= itemValues.size()) continue;
                    errorMsg.append(", ");
                }
                throw new BizServiceException("moreRecords", errorMsg.append("]").toString());
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected void checkRecordIfExist4Update(Map<String, Object> record) {
    }

    protected void setValue4Create(T record, Object optionParam) {
    }

    protected void setValue4Update(T record, Object optionParam) {
    }

    protected void setValue4Update(Map<String, Object> record, Object optionParam) {
    }

    protected void addPageExtraInfo(app.myoss.cloud.core.lang.dto.Page<T> condition, app.myoss.cloud.core.lang.dto.Page<T> result) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> I create(T record, Object optionParam) {
        this.createValidate(record, optionParam);
        return this.createCallable(record, optionParam, () -> this.createInner(record, optionParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> I create(T record) {
        return this.createInner(record, null);
    }

    protected <I> I createCallable(T record, Object optionParam, CallableFunc<I> createCallFunc) {
        return (I)createCallFunc.call();
    }

    protected <I> I createInner(T record, Object optionParam) {
        this.checkRecordIfExist4Create(record);
        this.setValue4Create(record, optionParam);
        boolean flag = DbUtils.checkDBResult(this.crudMapper.insert(record));
        if (flag) {
            return this.getPrimaryKeyValue(record);
        }
        throw new BizServiceException("insertDBFailed", "\u63d2\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
    }

    protected <I> I getPrimaryKeyValue(T record) {
        Set<TableColumnInfo> primaryKeyColumns = this.tableInfo.getPrimaryKeyColumns();
        int size = primaryKeyColumns.size();
        if (size == 0) {
            return null;
        }
        Object value = size == 1 ? null : new Object[size];
        int idx = 0;
        for (TableColumnInfo columnInfo : primaryKeyColumns) {
            Object tmp = BeanUtil.methodInvoke((Method)columnInfo.getPropertyDescriptor().getReadMethod(), record, (Object[])new Object[0]);
            if (size > 1) {
                value[idx++] = tmp;
                continue;
            }
            value = tmp;
        }
        return (I)value;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<T> records, Object optionParam) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        this.createBatchCallable(records, optionParam, (CallableFunc<Boolean>)((CallableFunc)() -> {
            this.createBatchInner(records, optionParam);
            return true;
        }));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(List<T> records) {
        this.createBatch(records, null);
    }

    protected void createBatchCallable(List<T> records, Object optionParam, CallableFunc<Boolean> createCallFunc) {
        createCallFunc.call();
    }

    protected void createBatchInner(List<T> records, Object optionParam) {
        for (T record : records) {
            this.createValidate(record, optionParam);
            this.checkRecordIfExist4Create(record);
        }
        for (T record : records) {
            this.setValue4Create(record, optionParam);
            boolean flag = DbUtils.checkDBResult(this.crudMapper.insert(record));
            if (flag) continue;
            throw new BizServiceException("insertDBFailed", "\u63d2\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002[" + record + "]");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> I save(T record) {
        return this.save(record, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> I save(T record, Object optionParam) {
        this.createValidate(record, optionParam);
        return this.createCallable(record, optionParam, () -> this.saveInner(record, optionParam));
    }

    protected <I> I saveInner(T record, Object optionParam) {
        List<T> exists = this.findExistRecord4CheckRecord(record);
        if (CollectionUtils.isEmpty(exists)) {
            this.setValue4Create(record, optionParam);
            boolean flag = DbUtils.checkDBResult(this.crudMapper.insert(record));
            if (flag) {
                return this.getPrimaryKeyValue(record);
            }
            throw new BizServiceException("insertDBFailed", "\u63d2\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
        }
        return this.getPrimaryKeyValue(exists.get(0));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> I saveOrUpdate(T record) {
        return this.saveOrUpdate(record, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> I saveOrUpdate(T record, Object optionParam) {
        I primaryKeyValue = this.getPrimaryKeyValue(record);
        if (primaryKeyValue == null) {
            return this.create(record, optionParam);
        }
        this.updateByPrimaryKey(record, optionParam);
        return this.getPrimaryKeyValue(record);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByPrimaryKey(T record, Object optionParam) {
        this.checkPrimaryKeyIsNull(SqlCommandType.UPDATE, record);
        this.validFieldValue(record, optionParam);
        this.updateByPrimaryKeyCallable(record, optionParam, (CallableFunc<Boolean>)((CallableFunc)() -> {
            this.updateByPrimaryKeyInner(record, optionParam);
            return true;
        }));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByPrimaryKey(T record) {
        this.updateByPrimaryKey(record, null);
    }

    protected void updateByPrimaryKeyCallable(T record, Object optionParam, CallableFunc<Boolean> updateCallFunc) {
        updateCallFunc.call();
    }

    protected void updateByPrimaryKeyInner(T record, Object optionParam) {
        this.checkRecordIfExist4Update(record);
        this.setValue4Update(record, optionParam);
        boolean flag = DbUtils.checkDBResult(this.crudMapper.updateByPrimaryKey(record));
        if (!flag) {
            throw new BizServiceException("notMatchRecords", "\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByCondition(T record, T condition, Object optionParam) {
        this.validFieldValue(record, optionParam);
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.UPDATE, condition, null);
        this.updateByConditionCallable(record, condition, optionParam, (CallableFunc<Boolean>)((CallableFunc)() -> {
            this.updateByConditionInner(record, condition, optionParam);
            return true;
        }));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByCondition(T record, T condition) {
        this.updateByCondition(record, condition, null);
    }

    protected void updateByConditionCallable(T record, T condition, Object optionParam, CallableFunc<Boolean> updateCallFunc) {
        updateCallFunc.call();
    }

    protected void updateByConditionInner(T record, T condition, Object optionParam) {
        this.checkRecordIfExist4Update(record);
        this.setValue4Update(record, optionParam);
        boolean flag = DbUtils.checkDBResult(this.crudMapper.updateByCondition(record, condition));
        if (!flag) {
            throw new BizServiceException("notMatchRecords", "\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUseMapByCondition(Map<String, Object> record, T condition, Object optionParam) {
        this.validFieldValue(record, optionParam);
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.UPDATE, condition, null);
        this.updateUseMapByConditionCallable(record, condition, optionParam, (CallableFunc<Boolean>)((CallableFunc)() -> {
            this.updateUseMapByConditionInner(record, condition, optionParam);
            return true;
        }));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUseMapByCondition(Map<String, Object> record, T condition) {
        this.updateUseMapByCondition(record, condition, null);
    }

    protected void updateUseMapByConditionCallable(Map<String, Object> record, T condition, Object optionParam, CallableFunc<Boolean> updateCallFunc) {
        updateCallFunc.call();
    }

    protected void updateUseMapByConditionInner(Map<String, Object> record, T condition, Object optionParam) {
        this.checkRecordIfExist4Update(record);
        this.setValue4Update(record, optionParam);
        Map<String, Object> updateMap = this.convertToUpdateUseMap(record);
        boolean flag = DbUtils.checkDBResult(this.crudMapper.updateUseMapByCondition(updateMap, condition));
        if (!flag) {
            throw new BizServiceException("notMatchRecords", "\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPrimaryKey(T condition, Object optionParam) {
        this.checkPrimaryKeyIsNull(SqlCommandType.DELETE, condition);
        boolean flag = DbUtils.checkDBResult(this.crudMapper.deleteWithPrimaryKey(condition));
        if (!flag) {
            throw new BizServiceException("notMatchRecords", "\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPrimaryKey(T condition) {
        this.deleteByPrimaryKey(condition, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByCondition(T condition, Object optionParam) {
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.DELETE, condition, null);
        boolean flag = DbUtils.checkDBResult(this.crudMapper.deleteByCondition(condition));
        if (!flag) {
            throw new BizServiceException("notMatchRecords", "\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByCondition(T condition) {
        this.deleteByCondition(condition, null);
    }

    @Override
    public T findByPrimaryKey(Serializable id) {
        this.checkPrimaryKeyIsNull(SqlCommandType.SELECT, id);
        return this.crudMapper.selectByPrimaryKey(id);
    }

    @Override
    public T findByPrimaryKey(T condition) {
        this.checkPrimaryKeyIsNull(SqlCommandType.SELECT, condition);
        return this.crudMapper.selectWithPrimaryKey(condition);
    }

    @Override
    public T findOne(T condition) {
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, condition, null);
        return this.crudMapper.selectOne(condition);
    }

    @Override
    public List<T> findList(T condition) {
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, condition, null);
        return this.crudMapper.selectList(condition);
    }

    @Override
    public List<T> findListWithSort(app.myoss.cloud.core.lang.dto.Page<T> condition) {
        Object param = condition.getParam();
        Map extraInfo = condition.getExtraInfo();
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, param, extraInfo);
        Sort sort = condition.getSort();
        List<Order> orders = this.convertToOrders(sort);
        return this.crudMapper.selectListWithSort2((Object)param, extraInfo, orders);
    }

    @Override
    public Integer findCount(T condition) {
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, condition, null);
        return this.crudMapper.selectCount(condition);
    }

    @Override
    public Integer findCount(T condition, Map<String, Object> extraCondition) {
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, condition, extraCondition);
        return this.crudMapper.selectCount2(condition, extraCondition);
    }

    @Override
    public app.myoss.cloud.core.lang.dto.Page<T> findPage(app.myoss.cloud.core.lang.dto.Page<T> condition) {
        app.myoss.cloud.core.lang.dto.Page result = new app.myoss.cloud.core.lang.dto.Page();
        if (!this.checkPageConditionIsAllNull(condition, result)) {
            return result;
        }
        int pageSize = condition.getPageSize();
        int pageNum = condition.getPageNum();
        int dbPageNum = Math.max(0, pageNum - 1);
        int pageStart = dbPageNum * pageSize;
        Object param = condition.getParam();
        Sort sort = condition.getSort();
        List<Order> orders = this.convertToOrders(sort);
        Map extraInfo = condition.getExtraInfo();
        this.pageQuery(result, param, extraInfo, pageStart, pageSize, orders);
        result.setPageNum(dbPageNum + 1).setPageSize(pageSize);
        this.addPageExtraInfo(condition, result);
        return result;
    }

    protected void pageQuery(app.myoss.cloud.core.lang.dto.Page<T> result, T param, Map<String, Object> extraInfo, int pageStart, int pageSize, List<Order> orders) {
        List<T> details = this.crudMapper.selectPage2(param, extraInfo, pageStart, pageSize, orders);
        int totalCount = this.crudMapper.selectCount2(param, extraInfo);
        result.setValue(details).setTotalCount(totalCount).setPageSize(pageSize);
    }

    @Override
    public <DTO> app.myoss.cloud.core.lang.dto.Page<DTO> findPageByHelper(app.myoss.cloud.core.lang.dto.Page<DTO> condition) {
        int pageNum = condition.getPageNum();
        int pageSize = condition.getPageSize();
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize).doSelectPage(() -> this.pageHelperQuery(condition.getParam(), condition));
        app.myoss.cloud.core.lang.dto.Page pageResult = new app.myoss.cloud.core.lang.dto.Page();
        pageResult.setTotalCount(Math.toIntExact(page.getTotal())).setPageNum(pageNum).setPageSize(pageSize).setValue(page.getResult());
        return pageResult;
    }

    protected <DTO> List<DTO> pageHelperQuery(Object param, app.myoss.cloud.core.lang.dto.Page<DTO> condition) {
        return null;
    }
}

