/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.spring.boot.autoconfigure;

import app.myoss.cloud.mybatis.table.TableConfig;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="mybatis")
public class MybatisProperties {
    public static final String MYBATIS_PREFIX = "mybatis";
    public static final String MYBATIS_MAPPER_SCANNER_PREFIX = "mybatis.mapper-scanner";
    private static final ResourcePatternResolver RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver();
    private Boolean enabled;
    private String configLocation;
    private String[] mapperLocations;
    private String typeAliasesPackage;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Properties configurationProperties;
    @NestedConfigurationProperty
    private Configuration configuration;
    @NestedConfigurationProperty
    private TableConfig tableConfig;
    private MapperScanner mapperScanner;

    public Resource[] resolveMapperLocations() {
        return (Resource[])Stream.of((Object[])Optional.ofNullable(this.mapperLocations).orElse(new String[0])).flatMap(location -> Stream.of(this.getResources((String)location))).toArray(Resource[]::new);
    }

    private Resource[] getResources(String location) {
        try {
            return RESOURCE_RESOLVER.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public MapperScanner getMapperScanner() {
        return this.mapperScanner;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public void setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
    }

    public void setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }

    public void setMapperScanner(MapperScanner mapperScanner) {
        this.mapperScanner = mapperScanner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MybatisProperties)) {
            return false;
        }
        MybatisProperties other = (MybatisProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCheckConfigLocation() != other.isCheckConfigLocation()) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$configLocation = this.getConfigLocation();
        String other$configLocation = other.getConfigLocation();
        if (this$configLocation == null ? other$configLocation != null : !this$configLocation.equals(other$configLocation)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMapperLocations(), other.getMapperLocations())) {
            return false;
        }
        String this$typeAliasesPackage = this.getTypeAliasesPackage();
        String other$typeAliasesPackage = other.getTypeAliasesPackage();
        if (this$typeAliasesPackage == null ? other$typeAliasesPackage != null : !this$typeAliasesPackage.equals(other$typeAliasesPackage)) {
            return false;
        }
        String this$typeHandlersPackage = this.getTypeHandlersPackage();
        String other$typeHandlersPackage = other.getTypeHandlersPackage();
        if (this$typeHandlersPackage == null ? other$typeHandlersPackage != null : !this$typeHandlersPackage.equals(other$typeHandlersPackage)) {
            return false;
        }
        ExecutorType this$executorType = this.getExecutorType();
        ExecutorType other$executorType = other.getExecutorType();
        if (this$executorType == null ? other$executorType != null : !this$executorType.equals(other$executorType)) {
            return false;
        }
        Properties this$configurationProperties = this.getConfigurationProperties();
        Properties other$configurationProperties = other.getConfigurationProperties();
        if (this$configurationProperties == null ? other$configurationProperties != null : !((Object)this$configurationProperties).equals(other$configurationProperties)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        TableConfig this$tableConfig = this.getTableConfig();
        TableConfig other$tableConfig = other.getTableConfig();
        if (this$tableConfig == null ? other$tableConfig != null : !((Object)this$tableConfig).equals(other$tableConfig)) {
            return false;
        }
        MapperScanner this$mapperScanner = this.getMapperScanner();
        MapperScanner other$mapperScanner = other.getMapperScanner();
        return !(this$mapperScanner == null ? other$mapperScanner != null : !((Object)this$mapperScanner).equals(other$mapperScanner));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MybatisProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCheckConfigLocation() ? 79 : 97);
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $configLocation = this.getConfigLocation();
        result = result * 59 + ($configLocation == null ? 43 : $configLocation.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMapperLocations());
        String $typeAliasesPackage = this.getTypeAliasesPackage();
        result = result * 59 + ($typeAliasesPackage == null ? 43 : $typeAliasesPackage.hashCode());
        String $typeHandlersPackage = this.getTypeHandlersPackage();
        result = result * 59 + ($typeHandlersPackage == null ? 43 : $typeHandlersPackage.hashCode());
        ExecutorType $executorType = this.getExecutorType();
        result = result * 59 + ($executorType == null ? 43 : $executorType.hashCode());
        Properties $configurationProperties = this.getConfigurationProperties();
        result = result * 59 + ($configurationProperties == null ? 43 : ((Object)$configurationProperties).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        TableConfig $tableConfig = this.getTableConfig();
        result = result * 59 + ($tableConfig == null ? 43 : ((Object)$tableConfig).hashCode());
        MapperScanner $mapperScanner = this.getMapperScanner();
        result = result * 59 + ($mapperScanner == null ? 43 : ((Object)$mapperScanner).hashCode());
        return result;
    }

    public String toString() {
        return "MybatisProperties(enabled=" + this.getEnabled() + ", configLocation=" + this.getConfigLocation() + ", mapperLocations=" + Arrays.deepToString(this.getMapperLocations()) + ", typeAliasesPackage=" + this.getTypeAliasesPackage() + ", typeHandlersPackage=" + this.getTypeHandlersPackage() + ", checkConfigLocation=" + this.isCheckConfigLocation() + ", executorType=" + this.getExecutorType() + ", configurationProperties=" + this.getConfigurationProperties() + ", configuration=" + this.getConfiguration() + ", tableConfig=" + this.getTableConfig() + ", mapperScanner=" + this.getMapperScanner() + ")";
    }

    public static class MapperScanner {
        private String basePackage;
        private String sqlSessionFactoryName;
        private String sqlSessionTemplateBeanName;
        private Class<? extends Annotation> annotationClass;
        private Class<?> markerInterface;

        public String getBasePackage() {
            return this.basePackage;
        }

        public String getSqlSessionFactoryName() {
            return this.sqlSessionFactoryName;
        }

        public String getSqlSessionTemplateBeanName() {
            return this.sqlSessionTemplateBeanName;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        public Class<?> getMarkerInterface() {
            return this.markerInterface;
        }

        public void setBasePackage(String basePackage) {
            this.basePackage = basePackage;
        }

        public void setSqlSessionFactoryName(String sqlSessionFactoryName) {
            this.sqlSessionFactoryName = sqlSessionFactoryName;
        }

        public void setSqlSessionTemplateBeanName(String sqlSessionTemplateBeanName) {
            this.sqlSessionTemplateBeanName = sqlSessionTemplateBeanName;
        }

        public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
            this.annotationClass = annotationClass;
        }

        public void setMarkerInterface(Class<?> markerInterface) {
            this.markerInterface = markerInterface;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapperScanner)) {
                return false;
            }
            MapperScanner other = (MapperScanner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$basePackage = this.getBasePackage();
            String other$basePackage = other.getBasePackage();
            if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
                return false;
            }
            String this$sqlSessionFactoryName = this.getSqlSessionFactoryName();
            String other$sqlSessionFactoryName = other.getSqlSessionFactoryName();
            if (this$sqlSessionFactoryName == null ? other$sqlSessionFactoryName != null : !this$sqlSessionFactoryName.equals(other$sqlSessionFactoryName)) {
                return false;
            }
            String this$sqlSessionTemplateBeanName = this.getSqlSessionTemplateBeanName();
            String other$sqlSessionTemplateBeanName = other.getSqlSessionTemplateBeanName();
            if (this$sqlSessionTemplateBeanName == null ? other$sqlSessionTemplateBeanName != null : !this$sqlSessionTemplateBeanName.equals(other$sqlSessionTemplateBeanName)) {
                return false;
            }
            Class<? extends Annotation> this$annotationClass = this.getAnnotationClass();
            Class<? extends Annotation> other$annotationClass = other.getAnnotationClass();
            if (this$annotationClass == null ? other$annotationClass != null : !this$annotationClass.equals(other$annotationClass)) {
                return false;
            }
            Class<?> this$markerInterface = this.getMarkerInterface();
            Class<?> other$markerInterface = other.getMarkerInterface();
            return !(this$markerInterface == null ? other$markerInterface != null : !this$markerInterface.equals(other$markerInterface));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapperScanner;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $basePackage = this.getBasePackage();
            result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
            String $sqlSessionFactoryName = this.getSqlSessionFactoryName();
            result = result * 59 + ($sqlSessionFactoryName == null ? 43 : $sqlSessionFactoryName.hashCode());
            String $sqlSessionTemplateBeanName = this.getSqlSessionTemplateBeanName();
            result = result * 59 + ($sqlSessionTemplateBeanName == null ? 43 : $sqlSessionTemplateBeanName.hashCode());
            Class<? extends Annotation> $annotationClass = this.getAnnotationClass();
            result = result * 59 + ($annotationClass == null ? 43 : $annotationClass.hashCode());
            Class<?> $markerInterface = this.getMarkerInterface();
            result = result * 59 + ($markerInterface == null ? 43 : $markerInterface.hashCode());
            return result;
        }

        public String toString() {
            return "MybatisProperties.MapperScanner(basePackage=" + this.getBasePackage() + ", sqlSessionFactoryName=" + this.getSqlSessionFactoryName() + ", sqlSessionTemplateBeanName=" + this.getSqlSessionTemplateBeanName() + ", annotationClass=" + this.getAnnotationClass() + ", markerInterface=" + this.getMarkerInterface() + ")";
        }
    }
}

