/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.mapper.template.insert.impl;

import app.myoss.cloud.mybatis.executor.keygen.SequenceKeyGenerator;
import app.myoss.cloud.mybatis.mapper.template.AbstractMapperTemplate;
import app.myoss.cloud.mybatis.table.TableColumnInfo;
import app.myoss.cloud.mybatis.table.TableInfo;
import app.myoss.cloud.mybatis.table.TableMetaObject;
import app.myoss.cloud.mybatis.table.TableSequence;
import app.myoss.cloud.mybatis.table.annotation.FillRule;
import app.myoss.cloud.mybatis.table.annotation.GenerationType;
import app.myoss.cloud.mybatis.table.annotation.SequenceGenerator;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;

public class InsertMapperTemplate
extends AbstractMapperTemplate {
    private SelectKeyGenerator addSelectKeyGenerator(String id, TableSequence sequence, Class<?> parameterTypeClass, Configuration configuration, LanguageDriver langDriver, String parentId) {
        Class<?> resultTypeClass = sequence.getResultType()[0];
        StatementType statementType = sequence.getStatementType();
        String keyProperty = StringUtils.join((Object[])sequence.getKeyProperties(), (String)",");
        String keyColumn = StringUtils.join((Object[])sequence.getKeyColumns(), (String)",");
        boolean executeBefore = sequence.getOrder().equals((Object)SequenceGenerator.Order.BEFORE);
        String selectSql = sequence.getSql();
        StringBuilder sqlXml = new StringBuilder(150 + selectSql.length());
        sqlXml.append("<selectKey keyProperty=\"").append(keyProperty).append("\"");
        sqlXml.append(" keyColumn=\"").append(keyColumn).append("\"");
        if (resultTypeClass != null) {
            sqlXml.append(" resultType=\"").append(resultTypeClass.getCanonicalName()).append("\"");
        }
        sqlXml.append(" statementType=\"").append(statementType).append("\"");
        sqlXml.append(" order=\"").append((Object)sequence.getOrder()).append("\"");
        sqlXml.append(">").append(selectSql).append("</selectKey>");
        XPathParser xPathParser = new XPathParser(sqlXml.toString());
        XNode nodeToHandle = xPathParser.evalNode("selectKey");
        SqlSource sqlSource = langDriver.createSqlSource(configuration, nodeToHandle, parameterTypeClass);
        SqlCommandType sqlCommandType = SqlCommandType.SELECT;
        NoKeyGenerator keyGenerator = new NoKeyGenerator();
        MapperBuilderAssistant builderAssistant = new MapperBuilderAssistant(configuration, parentId);
        builderAssistant.setCurrentNamespace(StringUtils.substringBeforeLast((String)parentId, (String)"."));
        builderAssistant.addMappedStatement(id, sqlSource, statementType, sqlCommandType, null, null, null, parameterTypeClass, null, resultTypeClass, null, false, false, false, (KeyGenerator)keyGenerator, keyProperty, keyColumn, configuration.getDatabaseId(), langDriver, null);
        id = builderAssistant.applyCurrentNamespace(id, false);
        MappedStatement keyStatement = configuration.getMappedStatement(id, false);
        SelectKeyGenerator selectKeyGenerator = new SelectKeyGenerator(keyStatement, executeBefore);
        configuration.addKeyGenerator(id, (KeyGenerator)selectKeyGenerator);
        return selectKeyGenerator;
    }

    private GenerationType addKeyGenerator(TableInfo tableInfo, MetaObject metaObject, String id, Configuration configuration) {
        Object keyGenerator;
        TableSequence tableSequence = tableInfo.getTableSequence();
        if (tableSequence == null) {
            return null;
        }
        GenerationType strategy = tableSequence.getStrategy();
        if (strategy == GenerationType.USE_GENERATED_KEYS) {
            keyGenerator = new Jdbc3KeyGenerator();
        } else if (strategy == GenerationType.SELECT_KEY) {
            String selectId = StringUtils.substringAfterLast((String)id, (String)".") + "!selectKey";
            keyGenerator = this.addSelectKeyGenerator(selectId, tableSequence, tableInfo.getEntityClass(), configuration, (LanguageDriver)this.xmlLanguageDriver, id);
        } else if (strategy == GenerationType.SEQUENCE_KEY) {
            boolean executeBefore = tableSequence.getOrder().equals((Object)SequenceGenerator.Order.BEFORE);
            keyGenerator = new SequenceKeyGenerator(tableInfo, id, executeBefore);
        } else {
            throw new UnsupportedOperationException("keyGenerator strategy " + strategy.getType() + " unsupported");
        }
        metaObject.setValue("keyGenerator", keyGenerator);
        metaObject.setValue("keyProperties", (Object)tableSequence.getKeyProperties());
        metaObject.setValue("keyColumns", (Object)tableSequence.getKeyColumns());
        return strategy;
    }

    public String insertAllColumn(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        String id = ms.getId();
        Configuration configuration = ms.getConfiguration();
        this.addKeyGenerator(tableInfo, metaObject, id, configuration);
        StringBuilder builder = new StringBuilder(2048);
        builder.append("INSERT INTO ").append(TableMetaObject.getTableName(tableInfo)).append(" (");
        StringBuilder values = new StringBuilder(1024);
        for (TableColumnInfo columnInfo : tableInfo.getColumns()) {
            if (!columnInfo.isInsertable() || columnInfo.isAutoIncrement()) continue;
            builder.append(columnInfo.getActualColumn()).append(", ");
            values.append("#{").append(columnInfo.getProperty());
            values.append("}, ");
        }
        values.deleteCharAt(values.length() - 2);
        builder.deleteCharAt(builder.length() - 2).append(")\n");
        builder.append(" VALUES (").append((CharSequence)values).append(")");
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }

    public String insert(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        String id = ms.getId();
        Configuration configuration = ms.getConfiguration();
        GenerationType generationType = this.addKeyGenerator(tableInfo, metaObject, id, configuration);
        StringBuilder builder = new StringBuilder(4096);
        builder.append("INSERT INTO ").append(TableMetaObject.getTableName(tableInfo)).append("\n");
        builder.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">\n");
        StringBuilder values = new StringBuilder(2048);
        values.append("<trim prefix=\"values (\" suffix=\")\" suffixOverrides=\",\">\n");
        for (TableColumnInfo columnInfo : tableInfo.getColumns()) {
            boolean fillInsert;
            if (!columnInfo.isInsertable() || columnInfo.isAutoIncrement()) continue;
            boolean bl = fillInsert = columnInfo.isPrimaryKey() && GenerationType.USE_GENERATED_KEYS != generationType || columnInfo.haveFillRule(FillRule.INSERT) || columnInfo.isLogicDelete();
            if (!fillInsert) {
                builder.append("  <if test=\"").append(columnInfo.getProperty()).append(" != null\">\n");
            }
            builder.append("    ").append(columnInfo.getActualColumn()).append(",\n");
            if (!fillInsert) {
                builder.append("  </if>\n");
            }
            if (!fillInsert) {
                values.append("  <if test=\"").append(columnInfo.getProperty()).append(" != null\">\n");
            }
            values.append("    #{").append(columnInfo.getProperty());
            values.append("},\n");
            if (fillInsert) continue;
            values.append("  </if>\n");
        }
        builder.append("</trim>\n").append((CharSequence)values).append("</trim>\n");
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }

    public String insertBatch(TableInfo tableInfo, MappedStatement ms) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        String id = ms.getId();
        Configuration configuration = ms.getConfiguration();
        this.addKeyGenerator(tableInfo, metaObject, id, configuration);
        StringBuilder builder = new StringBuilder(2048);
        builder.append("INSERT INTO ").append(TableMetaObject.getTableName(tableInfo)).append(" (");
        StringBuilder values = new StringBuilder(1024);
        values.append("<foreach collection=\"list\" item=\"item\" separator=\",\">");
        values.append("\n(");
        for (TableColumnInfo columnInfo : tableInfo.getColumns()) {
            if (!columnInfo.isInsertable() || columnInfo.isAutoIncrement()) continue;
            builder.append(columnInfo.getActualColumn()).append(", ");
            values.append("#{item.").append(columnInfo.getProperty());
            values.append("}, ");
        }
        values.deleteCharAt(values.length() - 2).append(")\n</foreach>");
        builder.deleteCharAt(builder.length() - 2).append(")\n");
        builder.append(" values \n").append((CharSequence)values);
        String sql = builder.toString();
        SqlSource sqlSource = this.xmlLanguageDriver.createSqlSource(configuration, "<script>\n" + sql + "\n</script>", null);
        metaObject.setValue("sqlSource", (Object)sqlSource);
        return sql;
    }
}

