/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.mapper.template;

import app.myoss.cloud.core.exception.BizRuntimeException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractMapperTemplate {
    protected XMLLanguageDriver xmlLanguageDriver = new XMLLanguageDriver();

    public String dynamicSql(Object record) {
        return "dynamicSql";
    }

    public String getWhereExtend(MappedStatement ms) {
        Configuration configuration = ms.getConfiguration();
        String namespace = StringUtils.substringBeforeLast((String)ms.getId(), (String)".");
        String sqlId = namespace + ".Where_Extend";
        if (!configuration.getSqlFragments().containsKey(sqlId)) {
            return null;
        }
        XNode node = (XNode)configuration.getSqlFragments().get(sqlId);
        try {
            StringWriter nodeContent = AbstractMapperTemplate.getNodeContent(node.getNode());
            return nodeContent.toString();
        }
        catch (TransformerException e) {
            throw new BizRuntimeException("get sqlFragments content failed, sqlId: " + sqlId, (Throwable)e);
        }
    }

    public StringBuilder getWhereExtendCondition(MappedStatement ms) {
        Configuration configuration = ms.getConfiguration();
        String namespace = StringUtils.substringBeforeLast((String)ms.getId(), (String)".");
        String sqlId = namespace + ".Where_Extend_Condition";
        if (!configuration.getSqlFragments().containsKey(sqlId)) {
            return null;
        }
        XNode node = (XNode)configuration.getSqlFragments().get(sqlId);
        StringBuilder sb = new StringBuilder();
        sb.append("  <if test=\"condition != null\">\n    ");
        try {
            StringWriter nodeContent = AbstractMapperTemplate.getNodeContent(node.getNode());
            sb.append(nodeContent.toString());
            sb.append("\n  </if>\n");
        }
        catch (TransformerException e) {
            throw new BizRuntimeException("get sqlFragments content failed, sqlId: " + sqlId, (Throwable)e);
        }
        return sb;
    }

    public StringBuilder getWhereExtraCondition(MappedStatement ms) {
        Configuration configuration = ms.getConfiguration();
        String namespace = StringUtils.substringBeforeLast((String)ms.getId(), (String)".");
        String sqlId = namespace + ".Where_Extra_Condition";
        if (!configuration.getSqlFragments().containsKey(sqlId)) {
            return null;
        }
        XNode node = (XNode)configuration.getSqlFragments().get(sqlId);
        StringBuilder sb = new StringBuilder();
        sb.append("  <if test=\"extraCondition != null\">\n    ");
        try {
            StringWriter nodeContent = AbstractMapperTemplate.getNodeContent(node.getNode());
            sb.append(nodeContent.toString());
        }
        catch (TransformerException e) {
            throw new BizRuntimeException("get sqlFragments content failed, sqlId: " + sqlId, (Throwable)e);
        }
        sb.append("\n  </if>\n");
        return sb;
    }

    public static StringWriter getNodeContent(Node node) throws TransformerException {
        StringWriter writer = new StringWriter();
        StreamResult streamResult = new StreamResult(writer);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            DOMSource domSource = new DOMSource(item);
            transformer.transform(domSource, streamResult);
        }
        return writer;
    }
}

