/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.repository.service.impl;

import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.cloud.core.lang.bean.BeanUtil;
import app.myoss.cloud.core.lang.concurrent.CallableFunc;
import app.myoss.cloud.core.lang.dto.Order;
import app.myoss.cloud.core.lang.dto.Result;
import app.myoss.cloud.core.lang.dto.Sort;
import app.myoss.cloud.mybatis.mapper.template.CrudMapper;
import app.myoss.cloud.mybatis.repository.entity.LogicDeleteEntity;
import app.myoss.cloud.mybatis.repository.entity.PrimaryKeyEntity;
import app.myoss.cloud.mybatis.repository.service.CrudService;
import app.myoss.cloud.mybatis.repository.utils.CrudServiceUtils;
import app.myoss.cloud.mybatis.repository.utils.DbUtils;
import app.myoss.cloud.mybatis.table.TableColumnInfo;
import app.myoss.cloud.mybatis.table.TableInfo;
import app.myoss.cloud.mybatis.table.TableMetaObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class BaseCrudServiceImpl<M extends CrudMapper<T>, T>
implements CrudService<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseCrudServiceImpl.class);
    protected Class<?> mapperClass;
    protected Class<?> entityClass;
    protected TableInfo tableInfo;
    protected Map<String, String> fieldColumns;
    protected M crudMapper;

    public BaseCrudServiceImpl() {
        Class<?> clazz = this.getClass();
        Type genType = clazz.getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.mapperClass = (Class)params[0];
        this.entityClass = (Class)params[1];
    }

    @Autowired
    public void setCrudMapper(M crudMapper) {
        this.crudMapper = crudMapper;
        this.tableInfo = TableMetaObject.getTableInfo(this.entityClass);
        if (this.tableInfo != null) {
            this.fieldColumns = Collections.unmodifiableMap(this.tableInfo.getColumns().stream().collect(Collectors.toMap(TableColumnInfo::getProperty, TableColumnInfo::getActualColumn)));
        } else {
            log.error("[{}] getTableInfo failed in [{}]", this.entityClass, this.getClass());
        }
    }

    protected boolean checkNull4Create(Result<?> result, T record, Object optionParam) {
        if (!result.isSuccess()) {
            return false;
        }
        if (record == null) {
            result.setSuccess(false).setErrorCode("valueIsBlank").setErrorMsg("\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result.isSuccess();
    }

    protected boolean checkPrimaryKeyIsNull(SqlCommandType sqlCommandType, Result<?> result, Serializable id) {
        if (!result.isSuccess()) {
            return false;
        }
        if (id == null) {
            result.setSuccess(false).setErrorCode("valueIsBlank").setErrorMsg("\u4e3b\u952e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result.isSuccess();
    }

    protected boolean checkPrimaryKeyIsNull(SqlCommandType sqlCommandType, Object record, boolean checkAll) {
        return CrudServiceUtils.checkPrimaryKeyIsNull(this.tableInfo, record, checkAll);
    }

    protected boolean checkPrimaryKeyIsNull(SqlCommandType sqlCommandType, Result<?> result, Object record) {
        if (!result.isSuccess()) {
            return false;
        }
        boolean isNull = this.checkPrimaryKeyIsNull(sqlCommandType, record, true);
        if (isNull) {
            result.setSuccess(false).setErrorCode("valueIsBlank").setErrorMsg("\u4e3b\u952e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result.isSuccess();
    }

    protected boolean checkCommonQueryConditionIsAllNull(SqlCommandType sqlCommandType, Result<?> result, T condition, Map<String, Object> extraCondition) {
        if (!result.isSuccess()) {
            return false;
        }
        return this.checkPrimaryKeyIsNull(sqlCommandType, result, condition);
    }

    protected boolean checkPageConditionIsAllNull(app.myoss.cloud.core.lang.dto.Page<T> condition, app.myoss.cloud.core.lang.dto.Page<T> result) {
        return result.isSuccess();
    }

    protected boolean validFieldValue(Result<?> result, T record, Object optionParam) {
        if (!result.isSuccess()) {
            return false;
        }
        if (record == null) {
            result.setSuccess(false).setErrorCode("valueIsBlank").setErrorMsg("\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result.isSuccess();
    }

    protected boolean validFieldValue(Result<?> result, Map<String, Object> record, Object optionParam) {
        if (!result.isSuccess()) {
            return false;
        }
        if (record == null) {
            result.setSuccess(false).setErrorCode("valueIsBlank").setErrorMsg("\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return result.isSuccess();
    }

    protected boolean createValidate(Result<?> result, T record, Object optionParam) {
        if (!this.checkNull4Create(result, record, optionParam)) {
            return false;
        }
        return this.validFieldValue(result, record, optionParam);
    }

    protected Map<String, Object> convertToUpdateUseMap(Map<String, Object> record) {
        return CrudServiceUtils.convertToUpdateUseMap(this.fieldColumns, record, this.getClass());
    }

    protected List<Order> convertToOrders(Sort sort) {
        return CrudServiceUtils.convertToOrders(this.fieldColumns, sort, this.getClass());
    }

    protected List<T> findExistRecord4CheckRecord(Result<?> result, T record) {
        return null;
    }

    protected boolean checkRecordIfExist4Create(Result<?> result, T record) {
        List<T> exists = this.findExistRecord4CheckRecord(result, record);
        if (CollectionUtils.isEmpty(exists)) {
            return false;
        }
        result.setSuccess(false).setErrorCode("moreRecords");
        T item = exists.get(0);
        StringBuilder errorMsg = new StringBuilder();
        Iterator<TableColumnInfo> iterator = this.tableInfo.getPrimaryKeyColumns().iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            TableColumnInfo columnInfo = iterator.next();
            Object value = BeanUtil.methodInvoke((Method)columnInfo.getPropertyDescriptor().getReadMethod(), item, (Object[])new Object[0]);
            errorMsg.append(columnInfo.getProperty()).append("=").append(value);
            hasNext = iterator.hasNext();
            if (!hasNext) continue;
            errorMsg.append(", ");
        }
        if (errorMsg.length() > 0) {
            errorMsg.insert(0, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55\uff0c\u4e3b\u952e\u503c[").append("]");
            result.setErrorMsg(errorMsg.toString());
        } else {
            result.setErrorMsg("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55");
        }
        return true;
    }

    protected boolean checkRecordIfExist4Update(Result<?> result, T record) {
        if (record instanceof LogicDeleteEntity && StringUtils.equals((CharSequence)((LogicDeleteEntity)record).getIsDeleted(), (CharSequence)"Y")) {
            return false;
        }
        List<T> exists = this.findExistRecord4CheckRecord(result, record);
        if (CollectionUtils.isEmpty(exists)) {
            return false;
        }
        if (record instanceof PrimaryKeyEntity) {
            Object id = ((PrimaryKeyEntity)record).getPrimaryKey();
            for (T item : exists) {
                Object id1 = ((PrimaryKeyEntity)item).getPrimaryKey();
                if (id1.equals(id)) continue;
                result.setSuccess(false).setErrorCode("moreRecords").setErrorMsg("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55\uff0c\u4e3b\u952eid=" + id1);
                return true;
            }
            return false;
        }
        Set<TableColumnInfo> primaryKeyColumns = this.tableInfo.getPrimaryKeyColumns();
        if (!CollectionUtils.isEmpty(primaryKeyColumns)) {
            ArrayList<Object> sourceValues = new ArrayList<Object>(primaryKeyColumns.size());
            for (TableColumnInfo columnInfo : primaryKeyColumns) {
                Object value = BeanUtil.methodInvoke((Method)columnInfo.getPropertyDescriptor().getReadMethod(), record, (Object[])new Object[0]);
                sourceValues.add(value);
            }
            for (TableColumnInfo item : exists) {
                ArrayList<Object> itemValues = new ArrayList<Object>(primaryKeyColumns.size());
                for (TableColumnInfo columnInfo : primaryKeyColumns) {
                    Object value = BeanUtil.methodInvoke((Method)columnInfo.getPropertyDescriptor().getReadMethod(), (Object)item, (Object[])new Object[0]);
                    itemValues.add(value);
                }
                if (Objects.deepEquals(sourceValues, itemValues)) continue;
                StringBuilder errorMsg = new StringBuilder("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55\uff0c\u4e3b\u952e\u503c[");
                int idx = 0;
                for (TableColumnInfo columnInfo : primaryKeyColumns) {
                    Object value = itemValues.get(idx++);
                    errorMsg.append(columnInfo.getProperty()).append("=").append(value);
                    if (idx >= itemValues.size()) continue;
                    errorMsg.append(", ");
                }
                result.setErrorCode("moreRecords").setErrorMsg(errorMsg.append("]").toString());
            }
        } else {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    protected boolean checkRecordIfExist4Update(Result<?> result, Map<String, Object> record) {
        return false;
    }

    protected void setValue4Create(T record, Object optionParam) {
    }

    protected void setValue4Update(T record, Object optionParam) {
    }

    protected void setValue4Update(Map<String, Object> record, Object optionParam) {
    }

    protected void addPageExtraInfo(app.myoss.cloud.core.lang.dto.Page<T> condition, app.myoss.cloud.core.lang.dto.Page<T> result) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> Result<I> create(T record, Object optionParam) {
        Result result = new Result();
        boolean validate = this.createValidate(result, record, optionParam);
        if (!validate) {
            return result;
        }
        return this.createCallable(result, record, optionParam, () -> this.create(result, record, optionParam));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> Result<I> create(T record) {
        return this.create(record, null);
    }

    protected <I> Result<I> createCallable(Result<I> result, T record, Object optionParam, CallableFunc<Result<I>> createCallFunc) {
        return (Result)createCallFunc.call();
    }

    protected <I> Result<I> create(Result<I> result, T record, Object optionParam) {
        boolean ifExist = this.checkRecordIfExist4Create(result, record);
        if (!ifExist && result.isSuccess()) {
            this.setValue4Create(record, optionParam);
            boolean flag = DbUtils.checkDBResult(this.crudMapper.insert(record));
            if (flag) {
                return this.getPrimaryKeyValue(record, result);
            }
            result.setSuccess(false).setErrorCode("insertDBFailed").setErrorMsg("\u63d2\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
        }
        return result;
    }

    protected <I> Result<I> getPrimaryKeyValue(T record, Result<I> result) {
        Set<TableColumnInfo> primaryKeyColumns = this.tableInfo.getPrimaryKeyColumns();
        int size = primaryKeyColumns.size();
        if (size == 0) {
            return result;
        }
        Object value = size == 1 ? null : new Object[size];
        int idx = 0;
        for (TableColumnInfo columnInfo : primaryKeyColumns) {
            Object tmp = BeanUtil.methodInvoke((Method)columnInfo.getPropertyDescriptor().getReadMethod(), record, (Object[])new Object[0]);
            if (size > 1) {
                value[idx++] = tmp;
                continue;
            }
            value = tmp;
        }
        return result.setValue(value);
    }

    protected void setPrimaryKeyValue(T record, Object ... value) {
        Set<TableColumnInfo> primaryKeyColumns = this.tableInfo.getPrimaryKeyColumns();
        int size = primaryKeyColumns.size();
        if (size == 0) {
            return;
        }
        int idx = 0;
        for (TableColumnInfo columnInfo : primaryKeyColumns) {
            Method writeMethod = columnInfo.getPropertyDescriptor().getWriteMethod();
            try {
                writeMethod.invoke(record, value[idx++]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BizRuntimeException("updateEntityFieldFailed", "\u66f4\u65b0Entity\u4e3b\u952e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002[" + record + ", " + Arrays.toString(value) + "]", null);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> createBatch(List<T> records, Object optionParam) {
        Result result = new Result((Object)false);
        if (CollectionUtils.isEmpty(records)) {
            return result.setValue((Object)true);
        }
        return this.createBatchCallable((Result<Boolean>)result, records, optionParam, (CallableFunc<Result<Boolean>>)((CallableFunc)() -> this.createBatch((Result<Boolean>)result, records, optionParam)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> createBatch(List<T> records) {
        return this.createBatch(records, null);
    }

    protected Result<Boolean> createBatchCallable(Result<Boolean> result, List<T> records, Object optionParam, CallableFunc<Result<Boolean>> createCallFunc) {
        return (Result)createCallFunc.call();
    }

    protected Result<Boolean> createBatch(Result<Boolean> result, List<T> records, Object optionParam) {
        for (T record : records) {
            if (!this.createValidate(result, record, optionParam)) {
                return result;
            }
            boolean ifExist = this.checkRecordIfExist4Create(result, record);
            if (!ifExist && result.isSuccess()) continue;
            return result;
        }
        for (T record : records) {
            this.setValue4Create(record, optionParam);
            boolean flag = DbUtils.checkDBResult(this.crudMapper.insert(record));
            if (flag) continue;
            return result.setSuccess(false).setErrorCode("insertDBFailed").setErrorMsg("\u63d2\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002[" + record + "]");
        }
        return result.setValue((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> Result<I> save(T record) {
        return this.save(record, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> Result<I> save(T record, Object optionParam) {
        Result result = new Result();
        boolean validate = this.createValidate(result, record, optionParam);
        if (!validate) {
            return result;
        }
        return this.createCallable(result, record, optionParam, () -> this.save(result, record, optionParam));
    }

    protected <I> Result<I> save(Result<I> result, T record, Object optionParam) {
        List<T> exists = this.findExistRecord4CheckRecord(result, record);
        if (CollectionUtils.isEmpty(exists)) {
            this.setValue4Create(record, optionParam);
            boolean flag = DbUtils.checkDBResult(this.crudMapper.insert(record));
            if (flag) {
                return this.getPrimaryKeyValue(record, result);
            }
            return result.setSuccess(false).setErrorCode("insertDBFailed").setErrorMsg("\u63d2\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
        }
        return this.getPrimaryKeyValue(exists.get(0), result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> Result<I> saveOrUpdate(T record) {
        return this.saveOrUpdate(record, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public <I> Result<I> saveOrUpdate(T record, Object optionParam) {
        Result result = new Result();
        Result<I> primaryKeyValue = this.getPrimaryKeyValue(record, result);
        if (primaryKeyValue.getValue() == null) {
            List<T> exists = this.findExistRecord4CheckRecord(result, record);
            if (CollectionUtils.isEmpty(exists)) {
                return this.create(record, optionParam);
            }
            T exist = exists.get(0);
            if (exist == null) return this.create(record, optionParam);
            primaryKeyValue = this.getPrimaryKeyValue(record, result);
            this.setPrimaryKeyValue(record, primaryKeyValue.getValue());
            Result<Boolean> updateResult = this.updateByPrimaryKey(record, optionParam);
            result.setSuccess(updateResult.isSuccess()).setErrorCode(updateResult.getErrorCode()).setErrorMsg(updateResult.getErrorMsg()).setValue(primaryKeyValue.getValue()).setExtraInfo(updateResult.getExtraInfo());
            return result;
        } else {
            Result<Boolean> updateResult = this.updateByPrimaryKey(record, optionParam);
            result.setSuccess(updateResult.isSuccess()).setErrorCode(updateResult.getErrorCode()).setErrorMsg(updateResult.getErrorMsg()).setValue(primaryKeyValue.getValue()).setExtraInfo(updateResult.getExtraInfo());
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> updateByPrimaryKey(T record, Object optionParam) {
        Result result = new Result((Object)false);
        this.checkPrimaryKeyIsNull(SqlCommandType.UPDATE, result, record);
        this.validFieldValue(result, record, optionParam);
        if (!result.isSuccess()) {
            return result;
        }
        return this.updateByPrimaryKeyCallable((Result<Boolean>)result, record, optionParam, (CallableFunc<Result<Boolean>>)((CallableFunc)() -> this.updateByPrimaryKey((Result<Boolean>)result, record, optionParam)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> updateByPrimaryKey(T record) {
        return this.updateByPrimaryKey(record, null);
    }

    protected Result<Boolean> updateByPrimaryKeyCallable(Result<Boolean> result, T record, Object optionParam, CallableFunc<Result<Boolean>> updateCallFunc) {
        return (Result)updateCallFunc.call();
    }

    protected Result<Boolean> updateByPrimaryKey(Result<Boolean> result, T record, Object optionParam) {
        boolean ifExist = this.checkRecordIfExist4Update(result, record);
        if (!ifExist && result.isSuccess()) {
            this.setValue4Update(record, optionParam);
            boolean flag = DbUtils.checkDBResult(this.crudMapper.updateByPrimaryKey(record));
            if (!flag) {
                result.setSuccess(false).setErrorCode("notMatchRecords").setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
            } else {
                result.setValue((Object)true);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> updateByCondition(T record, T condition, Object optionParam) {
        Result result = new Result((Object)false);
        this.validFieldValue(result, record, optionParam);
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.UPDATE, result, condition, null);
        if (!result.isSuccess()) {
            return result;
        }
        return this.updateByConditionCallable((Result<Boolean>)result, record, condition, optionParam, (CallableFunc<Result<Boolean>>)((CallableFunc)() -> this.updateByCondition((Result<Boolean>)result, record, condition, optionParam)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> updateByCondition(T record, T condition) {
        return this.updateByCondition(record, condition, null);
    }

    protected Result<Boolean> updateByConditionCallable(Result<Boolean> result, T record, T condition, Object optionParam, CallableFunc<Result<Boolean>> updateCallFunc) {
        return (Result)updateCallFunc.call();
    }

    protected Result<Boolean> updateByCondition(Result<Boolean> result, T record, T condition, Object optionParam) {
        boolean ifExist = this.checkRecordIfExist4Update(result, record);
        if (!ifExist && result.isSuccess()) {
            this.setValue4Update(record, optionParam);
            boolean flag = DbUtils.checkDBResult(this.crudMapper.updateByCondition(record, condition));
            if (!flag) {
                result.setSuccess(false).setErrorCode("notMatchRecords").setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
            } else {
                result.setValue((Object)true);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> updateUseMapByCondition(Map<String, Object> record, T condition, Object optionParam) {
        Result result = new Result((Object)false);
        if (!this.validFieldValue(result, record, optionParam)) {
            return result;
        }
        this.checkCommonQueryConditionIsAllNull(SqlCommandType.UPDATE, result, condition, null);
        if (!result.isSuccess()) {
            return result;
        }
        return this.updateUseMapByConditionCallable((Result<Boolean>)result, record, condition, optionParam, (CallableFunc<Result<Boolean>>)((CallableFunc)() -> this.updateUseMapByCondition((Result<Boolean>)result, record, condition, optionParam)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> updateUseMapByCondition(Map<String, Object> record, T condition) {
        return this.updateUseMapByCondition(record, condition, null);
    }

    protected Result<Boolean> updateUseMapByConditionCallable(Result<Boolean> result, Map<String, Object> record, T condition, Object optionParam, CallableFunc<Result<Boolean>> updateCallFunc) {
        return (Result)updateCallFunc.call();
    }

    protected Result<Boolean> updateUseMapByCondition(Result<Boolean> result, Map<String, Object> record, T condition, Object optionParam) {
        boolean ifExist = this.checkRecordIfExist4Update(result, record);
        if (!ifExist && result.isSuccess()) {
            this.setValue4Update(record, optionParam);
            Map<String, Object> updateMap = this.convertToUpdateUseMap(record);
            boolean flag = DbUtils.checkDBResult(this.crudMapper.updateUseMapByCondition(updateMap, condition));
            if (!flag) {
                result.setSuccess(false).setErrorCode("notMatchRecords").setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
            } else {
                result.setValue((Object)true);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> deleteByPrimaryKey(T condition, Object optionParam) {
        Result result = new Result((Object)false);
        if (this.checkPrimaryKeyIsNull(SqlCommandType.DELETE, result, condition)) {
            boolean flag = DbUtils.checkDBResult(this.crudMapper.deleteWithPrimaryKey(condition));
            if (!flag) {
                result.setSuccess(false).setErrorCode("notMatchRecords").setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
            } else {
                result.setValue((Object)true);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> deleteByPrimaryKey(T condition) {
        return this.deleteByPrimaryKey(condition, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> deleteByCondition(T condition, Object optionParam) {
        Result result = new Result((Object)false);
        if (this.checkCommonQueryConditionIsAllNull(SqlCommandType.DELETE, result, condition, null)) {
            boolean flag = DbUtils.checkDBResult(this.crudMapper.deleteByCondition(condition));
            if (!flag) {
                result.setSuccess(false).setErrorCode("notMatchRecords").setErrorMsg("\u66f4\u65b0\u5931\u8d25\uff0c\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u8bb0\u5f55");
            } else {
                result.setValue((Object)true);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> deleteByCondition(T condition) {
        return this.deleteByCondition(condition, null);
    }

    @Override
    public Result<T> findByPrimaryKey(Serializable id) {
        Result result = new Result();
        if (this.checkPrimaryKeyIsNull(SqlCommandType.SELECT, result, id)) {
            Object entity = this.crudMapper.selectByPrimaryKey(id);
            result.setValue(entity);
        }
        return result;
    }

    @Override
    public Result<T> findByPrimaryKey(T condition) {
        Result result = new Result();
        if (this.checkPrimaryKeyIsNull(SqlCommandType.SELECT, result, condition)) {
            T entity = this.crudMapper.selectWithPrimaryKey(condition);
            result.setValue(entity);
        }
        return result;
    }

    @Override
    public Result<T> findOne(T condition) {
        Result result = new Result();
        if (this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, result, condition, null)) {
            T one = this.crudMapper.selectOne(condition);
            result.setValue(one);
        }
        return result;
    }

    @Override
    public Result<List<T>> findList(T condition) {
        Result result = new Result();
        if (this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, result, condition, null)) {
            List<T> list = this.crudMapper.selectList(condition);
            result.setValue(list);
        }
        return result;
    }

    @Override
    public Result<List<T>> findListWithSort(app.myoss.cloud.core.lang.dto.Page<T> condition) {
        Map extraInfo;
        Result result = new Result();
        Object param = condition.getParam();
        if (this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, result, param, extraInfo = condition.getExtraInfo())) {
            Sort sort = condition.getSort();
            List<Order> orders = this.convertToOrders(sort);
            List<Object> list = this.crudMapper.selectListWithSort2((Object)param, extraInfo, orders);
            result.setValue(list);
        }
        return result;
    }

    @Override
    public Result<Integer> findCount(T condition) {
        Result result = new Result();
        if (this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, result, condition, null)) {
            int count = this.crudMapper.selectCount(condition);
            result.setValue((Object)count);
        }
        return result;
    }

    @Override
    public Result<Integer> findCount(T condition, Map<String, Object> extraCondition) {
        Result result = new Result();
        if (this.checkCommonQueryConditionIsAllNull(SqlCommandType.SELECT, result, condition, extraCondition)) {
            int count = this.crudMapper.selectCount2(condition, extraCondition);
            result.setValue((Object)count);
        }
        return result;
    }

    @Override
    public app.myoss.cloud.core.lang.dto.Page<T> findPage(app.myoss.cloud.core.lang.dto.Page<T> condition) {
        app.myoss.cloud.core.lang.dto.Page result = new app.myoss.cloud.core.lang.dto.Page();
        if (!this.checkPageConditionIsAllNull(condition, result)) {
            return result;
        }
        int pageSize = condition.getPageSize();
        int pageNum = condition.getPageNum();
        int dbPageNum = Math.max(0, pageNum - 1);
        int pageStart = dbPageNum * pageSize;
        Object param = condition.getParam();
        Sort sort = condition.getSort();
        List<Order> orders = this.convertToOrders(sort);
        Map extraInfo = condition.getExtraInfo();
        this.pageQuery(result, param, extraInfo, pageStart, pageSize, orders);
        result.setPageNum(dbPageNum + 1).setPageSize(pageSize);
        this.addPageExtraInfo(condition, result);
        return result;
    }

    protected void pageQuery(app.myoss.cloud.core.lang.dto.Page<T> result, T param, Map<String, Object> extraInfo, int pageStart, int pageSize, List<Order> orders) {
        List<T> details = this.crudMapper.selectPage2(param, extraInfo, pageStart, pageSize, orders);
        int totalCount = this.crudMapper.selectCount2(param, extraInfo);
        result.setValue(details).setTotalCount(totalCount).setPageSize(pageSize);
    }

    @Override
    public <DTO> app.myoss.cloud.core.lang.dto.Page<DTO> findPageByHelper(app.myoss.cloud.core.lang.dto.Page<DTO> condition) {
        List<Order> orders = this.convertToOrders(condition.getSort());
        String orderBy = null;
        if (!CollectionUtils.isEmpty(orders)) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            for (Order order : orders) {
                stringJoiner.add(order.getProperty() + " " + order.getDirection().name());
            }
            orderBy = stringJoiner.toString();
        }
        int pageNum = condition.getPageNum();
        int pageSize = condition.getPageSize();
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize, orderBy).doSelectPage(() -> this.pageHelperQuery(condition.getParam(), condition));
        app.myoss.cloud.core.lang.dto.Page pageResult = new app.myoss.cloud.core.lang.dto.Page();
        pageResult.setTotalCount(Math.toIntExact(page.getTotal())).setPageNum(pageNum).setPageSize(pageSize).setValue(page.getResult());
        return pageResult;
    }

    protected <DTO> List<DTO> pageHelperQuery(Object param, app.myoss.cloud.core.lang.dto.Page<DTO> condition) {
        return null;
    }
}

