/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.spring.mapper;

import app.myoss.cloud.mybatis.mapper.register.MapperInterfaceRegister;
import app.myoss.cloud.mybatis.spring.mapper.ClassPathMapperScanner;
import app.myoss.cloud.mybatis.spring.mapper.MapperFactoryBean;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MapperScannerConfigurer
implements BeanDefinitionRegistryPostProcessor,
InitializingBean,
ApplicationContextAware,
BeanNameAware {
    private String basePackage;
    private boolean addToConfig = true;
    private String sqlSessionFactoryBeanName;
    private String sqlSessionTemplateBeanName;
    private Class<? extends Annotation> annotationClass;
    private Class<?> markerInterface;
    private MapperFactoryBean<?> mapperFactoryBean;
    private MapperInterfaceRegister mapperInterfaceRegister;
    private String mapperInterfaceRegisterBeanName;
    private ApplicationContext applicationContext;
    private String beanName;
    private boolean processPropertyPlaceHolders;
    private BeanNameGenerator nameGenerator;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.basePackage, (String)"Property 'basePackage' is required");
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        if (this.processPropertyPlaceHolders) {
            this.processPropertyPlaceHolders();
        }
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        scanner.setAddToConfig(this.addToConfig);
        scanner.setAnnotationClass(this.annotationClass);
        scanner.setMarkerInterface(this.markerInterface);
        scanner.setSqlSessionFactoryBeanName(this.sqlSessionFactoryBeanName);
        scanner.setSqlSessionTemplateBeanName(this.sqlSessionTemplateBeanName);
        if (this.mapperFactoryBean != null) {
            scanner.setMapperFactoryBean(this.mapperFactoryBean);
        }
        if (this.mapperInterfaceRegister != null) {
            scanner.setMapperInterfaceRegister(this.mapperInterfaceRegister);
        }
        if (!StringUtils.isEmpty((Object)this.mapperInterfaceRegisterBeanName)) {
            scanner.setMapperInterfaceRegisterBeanName(this.mapperInterfaceRegisterBeanName);
        }
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        scanner.setBeanNameGenerator(this.nameGenerator);
        scanner.registerFilters();
        String[] basePackages = StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n");
        scanner.scan(basePackages);
    }

    private void processPropertyPlaceHolders() {
        Map prcs = this.applicationContext.getBeansOfType(PropertyResourceConfigurer.class);
        if (!prcs.isEmpty() && this.applicationContext instanceof ConfigurableApplicationContext) {
            BeanDefinition mapperScannerBean = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getBeanDefinition(this.beanName);
            DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
            factory.registerBeanDefinition(this.beanName, mapperScannerBean);
            for (PropertyResourceConfigurer prc : prcs.values()) {
                prc.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
            }
            MutablePropertyValues values = mapperScannerBean.getPropertyValues();
            this.basePackage = this.updatePropertyValue("basePackage", (PropertyValues)values);
            this.sqlSessionFactoryBeanName = this.updatePropertyValue("sqlSessionFactoryBeanName", (PropertyValues)values);
            this.sqlSessionTemplateBeanName = this.updatePropertyValue("sqlSessionTemplateBeanName", (PropertyValues)values);
        }
    }

    private String updatePropertyValue(String propertyName, PropertyValues values) {
        PropertyValue property = values.getPropertyValue(propertyName);
        if (property == null) {
            return null;
        }
        Object value = property.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof TypedStringValue) {
            return ((TypedStringValue)value).getValue();
        }
        return null;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public boolean isAddToConfig() {
        return this.addToConfig;
    }

    public String getSqlSessionFactoryBeanName() {
        return this.sqlSessionFactoryBeanName;
    }

    public String getSqlSessionTemplateBeanName() {
        return this.sqlSessionTemplateBeanName;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public Class<?> getMarkerInterface() {
        return this.markerInterface;
    }

    public MapperFactoryBean<?> getMapperFactoryBean() {
        return this.mapperFactoryBean;
    }

    public MapperInterfaceRegister getMapperInterfaceRegister() {
        return this.mapperInterfaceRegister;
    }

    public String getMapperInterfaceRegisterBeanName() {
        return this.mapperInterfaceRegisterBeanName;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean isProcessPropertyPlaceHolders() {
        return this.processPropertyPlaceHolders;
    }

    public BeanNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public void setSqlSessionFactoryBeanName(String sqlSessionFactoryBeanName) {
        this.sqlSessionFactoryBeanName = sqlSessionFactoryBeanName;
    }

    public void setSqlSessionTemplateBeanName(String sqlSessionTemplateBeanName) {
        this.sqlSessionTemplateBeanName = sqlSessionTemplateBeanName;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void setMarkerInterface(Class<?> markerInterface) {
        this.markerInterface = markerInterface;
    }

    public void setMapperFactoryBean(MapperFactoryBean<?> mapperFactoryBean) {
        this.mapperFactoryBean = mapperFactoryBean;
    }

    public void setMapperInterfaceRegister(MapperInterfaceRegister mapperInterfaceRegister) {
        this.mapperInterfaceRegister = mapperInterfaceRegister;
    }

    public void setMapperInterfaceRegisterBeanName(String mapperInterfaceRegisterBeanName) {
        this.mapperInterfaceRegisterBeanName = mapperInterfaceRegisterBeanName;
    }

    public void setProcessPropertyPlaceHolders(boolean processPropertyPlaceHolders) {
        this.processPropertyPlaceHolders = processPropertyPlaceHolders;
    }

    public void setNameGenerator(BeanNameGenerator nameGenerator) {
        this.nameGenerator = nameGenerator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapperScannerConfigurer)) {
            return false;
        }
        MapperScannerConfigurer other = (MapperScannerConfigurer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAddToConfig() != other.isAddToConfig()) {
            return false;
        }
        if (this.isProcessPropertyPlaceHolders() != other.isProcessPropertyPlaceHolders()) {
            return false;
        }
        String this$basePackage = this.getBasePackage();
        String other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
            return false;
        }
        String this$sqlSessionFactoryBeanName = this.getSqlSessionFactoryBeanName();
        String other$sqlSessionFactoryBeanName = other.getSqlSessionFactoryBeanName();
        if (this$sqlSessionFactoryBeanName == null ? other$sqlSessionFactoryBeanName != null : !this$sqlSessionFactoryBeanName.equals(other$sqlSessionFactoryBeanName)) {
            return false;
        }
        String this$sqlSessionTemplateBeanName = this.getSqlSessionTemplateBeanName();
        String other$sqlSessionTemplateBeanName = other.getSqlSessionTemplateBeanName();
        if (this$sqlSessionTemplateBeanName == null ? other$sqlSessionTemplateBeanName != null : !this$sqlSessionTemplateBeanName.equals(other$sqlSessionTemplateBeanName)) {
            return false;
        }
        Class<? extends Annotation> this$annotationClass = this.getAnnotationClass();
        Class<? extends Annotation> other$annotationClass = other.getAnnotationClass();
        if (this$annotationClass == null ? other$annotationClass != null : !this$annotationClass.equals(other$annotationClass)) {
            return false;
        }
        Class<?> this$markerInterface = this.getMarkerInterface();
        Class<?> other$markerInterface = other.getMarkerInterface();
        if (this$markerInterface == null ? other$markerInterface != null : !this$markerInterface.equals(other$markerInterface)) {
            return false;
        }
        MapperFactoryBean<?> this$mapperFactoryBean = this.getMapperFactoryBean();
        MapperFactoryBean<?> other$mapperFactoryBean = other.getMapperFactoryBean();
        if (this$mapperFactoryBean == null ? other$mapperFactoryBean != null : !((Object)this$mapperFactoryBean).equals(other$mapperFactoryBean)) {
            return false;
        }
        MapperInterfaceRegister this$mapperInterfaceRegister = this.getMapperInterfaceRegister();
        MapperInterfaceRegister other$mapperInterfaceRegister = other.getMapperInterfaceRegister();
        if (this$mapperInterfaceRegister == null ? other$mapperInterfaceRegister != null : !this$mapperInterfaceRegister.equals(other$mapperInterfaceRegister)) {
            return false;
        }
        String this$mapperInterfaceRegisterBeanName = this.getMapperInterfaceRegisterBeanName();
        String other$mapperInterfaceRegisterBeanName = other.getMapperInterfaceRegisterBeanName();
        if (this$mapperInterfaceRegisterBeanName == null ? other$mapperInterfaceRegisterBeanName != null : !this$mapperInterfaceRegisterBeanName.equals(other$mapperInterfaceRegisterBeanName)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        String this$beanName = this.getBeanName();
        String other$beanName = other.getBeanName();
        if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
            return false;
        }
        BeanNameGenerator this$nameGenerator = this.getNameGenerator();
        BeanNameGenerator other$nameGenerator = other.getNameGenerator();
        return !(this$nameGenerator == null ? other$nameGenerator != null : !this$nameGenerator.equals(other$nameGenerator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MapperScannerConfigurer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAddToConfig() ? 79 : 97);
        result = result * 59 + (this.isProcessPropertyPlaceHolders() ? 79 : 97);
        String $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
        String $sqlSessionFactoryBeanName = this.getSqlSessionFactoryBeanName();
        result = result * 59 + ($sqlSessionFactoryBeanName == null ? 43 : $sqlSessionFactoryBeanName.hashCode());
        String $sqlSessionTemplateBeanName = this.getSqlSessionTemplateBeanName();
        result = result * 59 + ($sqlSessionTemplateBeanName == null ? 43 : $sqlSessionTemplateBeanName.hashCode());
        Class<? extends Annotation> $annotationClass = this.getAnnotationClass();
        result = result * 59 + ($annotationClass == null ? 43 : $annotationClass.hashCode());
        Class<?> $markerInterface = this.getMarkerInterface();
        result = result * 59 + ($markerInterface == null ? 43 : $markerInterface.hashCode());
        MapperFactoryBean<?> $mapperFactoryBean = this.getMapperFactoryBean();
        result = result * 59 + ($mapperFactoryBean == null ? 43 : ((Object)$mapperFactoryBean).hashCode());
        MapperInterfaceRegister $mapperInterfaceRegister = this.getMapperInterfaceRegister();
        result = result * 59 + ($mapperInterfaceRegister == null ? 43 : $mapperInterfaceRegister.hashCode());
        String $mapperInterfaceRegisterBeanName = this.getMapperInterfaceRegisterBeanName();
        result = result * 59 + ($mapperInterfaceRegisterBeanName == null ? 43 : $mapperInterfaceRegisterBeanName.hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        String $beanName = this.getBeanName();
        result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
        BeanNameGenerator $nameGenerator = this.getNameGenerator();
        result = result * 59 + ($nameGenerator == null ? 43 : $nameGenerator.hashCode());
        return result;
    }

    public String toString() {
        return "MapperScannerConfigurer(basePackage=" + this.getBasePackage() + ", addToConfig=" + this.isAddToConfig() + ", sqlSessionFactoryBeanName=" + this.getSqlSessionFactoryBeanName() + ", sqlSessionTemplateBeanName=" + this.getSqlSessionTemplateBeanName() + ", annotationClass=" + this.getAnnotationClass() + ", markerInterface=" + this.getMarkerInterface() + ", mapperFactoryBean=" + this.getMapperFactoryBean() + ", mapperInterfaceRegister=" + this.getMapperInterfaceRegister() + ", mapperInterfaceRegisterBeanName=" + this.getMapperInterfaceRegisterBeanName() + ", applicationContext=" + this.getApplicationContext() + ", beanName=" + this.getBeanName() + ", processPropertyPlaceHolders=" + this.isProcessPropertyPlaceHolders() + ", nameGenerator=" + this.getNameGenerator() + ")";
    }
}

