/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.type;

import app.myoss.cloud.mybatis.type.EnumValueMappedType;
import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValueAnnotationTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private static final Logger log = LoggerFactory.getLogger(EnumValueAnnotationTypeHandler.class);
    private static final Map<Class<?>, Field> ENUM_FIELDS = new ConcurrentHashMap();
    @NonNull
    private final Class<E> type;

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        Field field = ENUM_FIELDS.get(this.type);
        try {
            Object value = field.get(parameter);
            if (jdbcType == null) {
                ps.setObject(i, value);
            } else {
                ps.setObject(i, value, jdbcType.TYPE_CODE);
            }
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot convert " + i + " to " + this.type.getSimpleName() + " by ordinal value.", ex);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object value = rs.getObject(columnName);
        return EnumValueAnnotationTypeHandler.getEnum(this.type, value);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object value = rs.getObject(columnIndex);
        return EnumValueAnnotationTypeHandler.getEnum(this.type, value);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object value = cs.getObject(columnIndex);
        return EnumValueAnnotationTypeHandler.getEnum(this.type, value);
    }

    public static void registryEnumField(Class<?> clazz, Field field) {
        boolean flag;
        field.setAccessible(true);
        Field absent = ENUM_FIELDS.putIfAbsent(clazz, field);
        if (absent == null) {
            return;
        }
        boolean bl = flag = absent.getDeclaringClass() == field.getDeclaringClass() && Objects.equals(absent.getName(), field.getName());
        if (!flag) {
            throw new IllegalArgumentException(clazz + " contains multiple annotations '" + EnumValueMappedType.class.getCanonicalName() + "', please check field: " + absent.getName() + ", " + field.getName());
        }
    }

    private static <E extends Enum<E>> E getEnum(Class<E> enumClass, Object value) {
        Enum[] enumConstants;
        if (value == null) {
            return null;
        }
        Field field = ENUM_FIELDS.get(enumClass);
        for (Enum enumConstant : enumConstants = (Enum[])enumClass.getEnumConstants()) {
            try {
                if (!Objects.equals(field.get(enumConstant), value)) continue;
                return (E)enumConstant;
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Cannot invoke a method [" + field.getName() + "] for the " + value, ex);
            }
        }
        return null;
    }

    public EnumValueAnnotationTypeHandler(@NonNull Class<E> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }
}

