/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.miniapp.autoconfigure;

import app.myoss.cloud.core.spring.context.SpringContextHolder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="wechat.mini-app")
public class WeChatMiniAppProperties {
    private boolean enabled;
    private WeChatMiniApp config;
    private Map<String, WeChatMiniApp> configs;

    public WeChatMiniApp getByCustomAppId(String customAppId) {
        if (StringUtils.isBlank((CharSequence)customAppId)) {
            return null;
        }
        if (this.config != null && customAppId.equals(this.config.getCustomAppId())) {
            return this.config;
        }
        for (WeChatMiniApp weChatMiniApp : this.configs.values()) {
            if (!customAppId.equals(weChatMiniApp.getCustomAppId())) continue;
            return weChatMiniApp;
        }
        return null;
    }

    public WeChatMiniApp getByOriginalId(String originalId) {
        if (StringUtils.isBlank((CharSequence)originalId)) {
            return null;
        }
        if (this.config != null && originalId.equals(this.config.getOriginalId())) {
            return this.config;
        }
        for (WeChatMiniApp weChatMiniApp : this.configs.values()) {
            if (!originalId.equals(weChatMiniApp.getAppId())) continue;
            return weChatMiniApp;
        }
        return null;
    }

    public WeChatMiniApp getByAppId(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (this.config != null && appId.equals(this.config.getAppId())) {
            return this.config;
        }
        for (WeChatMiniApp weChatMiniApp : this.configs.values()) {
            if (!appId.equals(weChatMiniApp.getAppId())) continue;
            return weChatMiniApp;
        }
        return null;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WeChatMiniApp getConfig() {
        return this.config;
    }

    public Map<String, WeChatMiniApp> getConfigs() {
        return this.configs;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setConfig(WeChatMiniApp config) {
        this.config = config;
    }

    public void setConfigs(Map<String, WeChatMiniApp> configs) {
        this.configs = configs;
    }

    public static class WeChatMiniApp {
        private String appName;
        private String customAppId;
        private String originalId;
        private String appId;
        @JSONField(serialize=false)
        private String appSecret;
        @JSONField(serialize=false)
        private String token;
        @JSONField(serialize=false)
        private String encodingAesKey;
        private String msgDataFormat;

        public <T> T getSpringBeanByCustomAppId(Class<T> clazz) {
            String name = this.customAppId + clazz.getSimpleName();
            return (T)SpringContextHolder.getBean((String)name, clazz);
        }

        public String toString() {
            return JSON.toJSONString((Object)this);
        }

        public String getAppName() {
            return this.appName;
        }

        public String getCustomAppId() {
            return this.customAppId;
        }

        public String getOriginalId() {
            return this.originalId;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        public String getToken() {
            return this.token;
        }

        public String getEncodingAesKey() {
            return this.encodingAesKey;
        }

        public String getMsgDataFormat() {
            return this.msgDataFormat;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setCustomAppId(String customAppId) {
            this.customAppId = customAppId;
        }

        public void setOriginalId(String originalId) {
            this.originalId = originalId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setEncodingAesKey(String encodingAesKey) {
            this.encodingAesKey = encodingAesKey;
        }

        public void setMsgDataFormat(String msgDataFormat) {
            this.msgDataFormat = msgDataFormat;
        }
    }
}

