/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.miniapp.autoconfigure;

import app.myoss.cloud.core.lang.json.JsonApi;
import app.myoss.cloud.core.spring.context.SpringContextHolder;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="wechat.mini-app")
public class WeChatMiniAppProperties {
    private boolean enabled;
    private WeChatMiniApp config;
    private Map<String, WeChatMiniApp> configs;

    public WeChatMiniApp getByCustomAppId(String customAppId) {
        if (StringUtils.isBlank((CharSequence)customAppId)) {
            return null;
        }
        if (this.config != null && customAppId.equals(this.config.getCustomAppId())) {
            return this.config;
        }
        for (WeChatMiniApp weChatMiniApp : this.configs.values()) {
            if (!customAppId.equals(weChatMiniApp.getCustomAppId())) continue;
            return weChatMiniApp;
        }
        return null;
    }

    public WeChatMiniApp getByOriginalId(String originalId) {
        if (StringUtils.isBlank((CharSequence)originalId)) {
            return null;
        }
        if (this.config != null && originalId.equals(this.config.getOriginalId())) {
            return this.config;
        }
        for (WeChatMiniApp weChatMiniApp : this.configs.values()) {
            if (!originalId.equals(weChatMiniApp.getAppId())) continue;
            return weChatMiniApp;
        }
        return null;
    }

    public WeChatMiniApp getByAppId(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (this.config != null && appId.equals(this.config.getAppId())) {
            return this.config;
        }
        for (WeChatMiniApp weChatMiniApp : this.configs.values()) {
            if (!appId.equals(weChatMiniApp.getAppId())) continue;
            return weChatMiniApp;
        }
        return null;
    }

    public String toString() {
        return JsonApi.toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeChatMiniAppProperties)) {
            return false;
        }
        WeChatMiniAppProperties other = (WeChatMiniAppProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        WeChatMiniApp this$config = this.getConfig();
        WeChatMiniApp other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        Map<String, WeChatMiniApp> this$configs = this.getConfigs();
        Map<String, WeChatMiniApp> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeChatMiniAppProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        WeChatMiniApp $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        Map<String, WeChatMiniApp> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WeChatMiniApp getConfig() {
        return this.config;
    }

    public Map<String, WeChatMiniApp> getConfigs() {
        return this.configs;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setConfig(WeChatMiniApp config) {
        this.config = config;
    }

    public void setConfigs(Map<String, WeChatMiniApp> configs) {
        this.configs = configs;
    }

    public static class WeChatMiniApp {
        private String appName;
        private String customAppId;
        private String originalId;
        private String appId;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Expose(serialize=false)
        @JSONField(serialize=false)
        private String appSecret;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Expose(serialize=false)
        @JSONField(serialize=false)
        private String token;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Expose(serialize=false)
        @JSONField(serialize=false)
        private String encodingAesKey;
        private String msgDataFormat;

        public <T> T getSpringBeanByCustomAppId(Class<T> clazz) {
            String name = this.customAppId + clazz.getSimpleName();
            return (T)SpringContextHolder.getBean((String)name, clazz);
        }

        public String toString() {
            return JsonApi.toJson((Object)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeChatMiniApp)) {
                return false;
            }
            WeChatMiniApp other = (WeChatMiniApp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appName = this.getAppName();
            String other$appName = other.getAppName();
            if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
                return false;
            }
            String this$customAppId = this.getCustomAppId();
            String other$customAppId = other.getCustomAppId();
            if (this$customAppId == null ? other$customAppId != null : !this$customAppId.equals(other$customAppId)) {
                return false;
            }
            String this$originalId = this.getOriginalId();
            String other$originalId = other.getOriginalId();
            if (this$originalId == null ? other$originalId != null : !this$originalId.equals(other$originalId)) {
                return false;
            }
            String this$appId = this.getAppId();
            String other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                return false;
            }
            String this$appSecret = this.getAppSecret();
            String other$appSecret = other.getAppSecret();
            if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$encodingAesKey = this.getEncodingAesKey();
            String other$encodingAesKey = other.getEncodingAesKey();
            if (this$encodingAesKey == null ? other$encodingAesKey != null : !this$encodingAesKey.equals(other$encodingAesKey)) {
                return false;
            }
            String this$msgDataFormat = this.getMsgDataFormat();
            String other$msgDataFormat = other.getMsgDataFormat();
            return !(this$msgDataFormat == null ? other$msgDataFormat != null : !this$msgDataFormat.equals(other$msgDataFormat));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WeChatMiniApp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appName = this.getAppName();
            result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
            String $customAppId = this.getCustomAppId();
            result = result * 59 + ($customAppId == null ? 43 : $customAppId.hashCode());
            String $originalId = this.getOriginalId();
            result = result * 59 + ($originalId == null ? 43 : $originalId.hashCode());
            String $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
            String $appSecret = this.getAppSecret();
            result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $encodingAesKey = this.getEncodingAesKey();
            result = result * 59 + ($encodingAesKey == null ? 43 : $encodingAesKey.hashCode());
            String $msgDataFormat = this.getMsgDataFormat();
            result = result * 59 + ($msgDataFormat == null ? 43 : $msgDataFormat.hashCode());
            return result;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getCustomAppId() {
            return this.customAppId;
        }

        public String getOriginalId() {
            return this.originalId;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        public String getToken() {
            return this.token;
        }

        public String getEncodingAesKey() {
            return this.encodingAesKey;
        }

        public String getMsgDataFormat() {
            return this.msgDataFormat;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setCustomAppId(String customAppId) {
            this.customAppId = customAppId;
        }

        public void setOriginalId(String originalId) {
            this.originalId = originalId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public void setEncodingAesKey(String encodingAesKey) {
            this.encodingAesKey = encodingAesKey;
        }

        public void setMsgDataFormat(String msgDataFormat) {
            this.msgDataFormat = msgDataFormat;
        }
    }
}

