/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.mp.api.impl;

import app.myoss.cloud.cache.lock.LockService;
import app.myoss.cloud.cache.lock.functions.LockFunction;
import app.myoss.cloud.core.exception.BizRuntimeException;
import app.myoss.wechat.mp.api.WeChatMpDynamicConfigStorage;
import app.myoss.wechat.mp.api.impl.LockService4Jdk;
import app.myoss.wechat.mp.autoconfigure.WeChatMpProperties;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.springframework.data.redis.core.StringRedisTemplate;

public class WeChatMpDynamicConfigInRedisStorage
implements WeChatMpDynamicConfigStorage {
    private static final String ACCESS_TOKEN_KEY = "wechat_mp_access_token_";
    private static final String JSAPI_TICKET_KEY = "wechat_mp_jsapi_ticket_";
    private static final String CARD_API_TICKET_KEY = "wechat_card_api_ticket_";
    private WeChatMpProperties.WeChatMp weChatMp;
    private LockService lockService;
    private int lockTime;
    private StringRedisTemplate redisTemplate;
    private String accessTokenKey;
    private String jsapiTicketKey;
    private String cardApiTicketKey;
    private Map<String, LockService4Jdk> lockService4JdkMap = new ConcurrentHashMap<String, LockService4Jdk>();

    public WeChatMpDynamicConfigInRedisStorage(WeChatMpProperties.WeChatMp weChatMp, LockService lockService, int lockTime, StringRedisTemplate redisTemplate) {
        this.weChatMp = weChatMp;
        this.lockService = lockService;
        this.lockTime = lockTime;
        this.redisTemplate = redisTemplate;
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(weChatMp.getAppId());
        this.jsapiTicketKey = JSAPI_TICKET_KEY.concat(weChatMp.getAppId());
        this.cardApiTicketKey = CARD_API_TICKET_KEY.concat(weChatMp.getAppId());
    }

    @Override
    public String getAccessToken() {
        return (String)this.redisTemplate.opsForValue().get((Object)this.accessTokenKey);
    }

    @Override
    public boolean isAccessTokenExpired() {
        Long expire = this.redisTemplate.getExpire((Object)this.accessTokenKey);
        return expire == null || expire < 2L;
    }

    @Override
    public long getExpiresTime() {
        Long expire = this.redisTemplate.getExpire((Object)this.accessTokenKey);
        return expire != null ? expire : -2L;
    }

    @Override
    public void updateAccessToken(final String accessToken, final int expiresInSeconds) {
        String lockKey = "updateAccessTokenLockKey_" + this.accessTokenKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.opsForValue().set((Object)WeChatMpDynamicConfigInRedisStorage.this.accessTokenKey, (Object)accessToken, (long)(expiresInSeconds - 200), TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("updateAccessToken lock failed");
            }
        });
    }

    @Override
    public void expireAccessToken() {
        String lockKey = "expireAccessTokenLockKey_" + this.accessTokenKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.expire((Object)WeChatMpDynamicConfigInRedisStorage.this.accessTokenKey, 0L, TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("expireAccessToken lock failed");
            }
        });
    }

    @Override
    public Lock getLock(String key) {
        return this.lockService4JdkMap.computeIfAbsent(key, s -> new LockService4Jdk(key, this.lockService));
    }

    @Override
    public String getJsapiTicket() {
        return (String)this.redisTemplate.opsForValue().get((Object)this.jsapiTicketKey);
    }

    @Override
    public boolean isJsapiTicketExpired() {
        Long expire = this.redisTemplate.getExpire((Object)this.jsapiTicketKey);
        return expire == null || expire < 2L;
    }

    @Override
    public long getJsapiTicketExpiresTime() {
        Long expire = this.redisTemplate.getExpire((Object)this.jsapiTicketKey);
        return expire != null ? expire : -2L;
    }

    @Override
    public void expireJsapiTicket() {
        String lockKey = "expireJsapiTicketLockKey_" + this.jsapiTicketKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.expire((Object)WeChatMpDynamicConfigInRedisStorage.this.jsapiTicketKey, 0L, TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("expireJsapiTicket lock failed");
            }
        });
    }

    @Override
    public void updateJsapiTicket(final String jsapiTicket, final int expiresInSeconds) {
        String lockKey = "updateJsapiTicketLockKey_" + this.jsapiTicketKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.opsForValue().set((Object)WeChatMpDynamicConfigInRedisStorage.this.jsapiTicketKey, (Object)jsapiTicket, (long)(expiresInSeconds - 200), TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("updateJsapiTicket lock failed");
            }
        });
    }

    @Override
    public String getCardApiTicket() {
        return (String)this.redisTemplate.opsForValue().get((Object)this.cardApiTicketKey);
    }

    @Override
    public boolean isCardApiTicketExpired() {
        Long expire = this.redisTemplate.getExpire((Object)this.cardApiTicketKey);
        return expire == null || expire < 2L;
    }

    @Override
    public long getCardApiTicketExpiresTime() {
        Long expire = this.redisTemplate.getExpire((Object)this.cardApiTicketKey);
        return expire != null ? expire : -2L;
    }

    @Override
    public void expireCardApiTicket() {
        String lockKey = "expireCardApiTicketLockKey_" + this.cardApiTicketKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.expire((Object)WeChatMpDynamicConfigInRedisStorage.this.cardApiTicketKey, 0L, TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("expireCardApiTicket lock failed");
            }
        });
    }

    @Override
    public void updateCardApiTicket(final String cardApiTicket, final int expiresInSeconds) {
        String lockKey = "updateCardApiTicketLockKey_" + this.cardApiTicketKey;
        this.lockService.executeByLock((Serializable)((Object)lockKey), this.getLockTime(), new LockFunction(){

            public void onLockSuccess() {
                WeChatMpDynamicConfigInRedisStorage.this.redisTemplate.opsForValue().set((Object)WeChatMpDynamicConfigInRedisStorage.this.cardApiTicketKey, (Object)cardApiTicket, (long)(expiresInSeconds - 200), TimeUnit.SECONDS);
            }

            public void onLockFailed() {
                throw new BizRuntimeException("updateCardApiTicket lock failed");
            }
        });
    }

    public WeChatMpProperties.WeChatMp getWeChatMp() {
        return this.weChatMp;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    public int getLockTime() {
        return this.lockTime;
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public String getAccessTokenKey() {
        return this.accessTokenKey;
    }

    public String getJsapiTicketKey() {
        return this.jsapiTicketKey;
    }

    public String getCardApiTicketKey() {
        return this.cardApiTicketKey;
    }

    public Map<String, LockService4Jdk> getLockService4JdkMap() {
        return this.lockService4JdkMap;
    }
}

