/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.mp.api.impl;

import app.myoss.cloud.cache.lock.LockService;
import app.myoss.wechat.mp.api.WeChatMpDynamicConfigStorage;
import app.myoss.wechat.mp.autoconfigure.WeChatMpProperties;
import java.io.File;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;
import me.chanjar.weixin.mp.bean.WxMpHostConfig;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.enums.TicketType;
import org.springframework.data.redis.core.StringRedisTemplate;

public class WeChatMpInRedisConfigStorage
implements WxMpConfigStorage {
    private WeChatMpProperties.WeChatMp weChatMp;
    private WeChatMpDynamicConfigStorage weChatMpDynamicConfigStorage;
    private LockService lockService;
    private int lockTime;
    private StringRedisTemplate redisTemplate;

    public String getAccessToken() {
        return this.weChatMpDynamicConfigStorage.getAccessToken();
    }

    public Lock getAccessTokenLock() {
        return this.weChatMpDynamicConfigStorage.getLock("accessTokenLock");
    }

    public boolean isAccessTokenExpired() {
        return this.weChatMpDynamicConfigStorage.isAccessTokenExpired();
    }

    public void expireAccessToken() {
        this.weChatMpDynamicConfigStorage.expireAccessToken();
    }

    public void updateAccessToken(WxAccessToken accessToken) {
        this.weChatMpDynamicConfigStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
    }

    public void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.weChatMpDynamicConfigStorage.updateAccessToken(accessToken, expiresInSeconds);
    }

    public String getAppId() {
        return this.weChatMp.getAppId();
    }

    public String getSecret() {
        return this.weChatMp.getAppSecret();
    }

    public String getToken() {
        return this.weChatMp.getToken();
    }

    public String getAesKey() {
        return this.weChatMp.getEncodingAesKey();
    }

    public String getTemplateId() {
        return null;
    }

    public long getExpiresTime() {
        return this.weChatMpDynamicConfigStorage.getExpiresTime();
    }

    public String getOauth2redirectUri() {
        return null;
    }

    public String getHttpProxyHost() {
        return null;
    }

    public int getHttpProxyPort() {
        return 0;
    }

    public String getHttpProxyUsername() {
        return null;
    }

    public String getHttpProxyPassword() {
        return null;
    }

    public File getTmpDirFile() {
        return null;
    }

    public ApacheHttpClientBuilder getApacheHttpClientBuilder() {
        return null;
    }

    public boolean autoRefreshToken() {
        return true;
    }

    public String getTicket(TicketType type) {
        switch (type) {
            case JSAPI: {
                return this.weChatMpDynamicConfigStorage.getJsapiTicket();
            }
            case WX_CARD: {
                return this.weChatMpDynamicConfigStorage.getCardApiTicket();
            }
        }
        throw new UnsupportedOperationException("ticketType = " + type.name());
    }

    public Lock getTicketLock(TicketType type) {
        switch (type) {
            case JSAPI: {
                return this.weChatMpDynamicConfigStorage.getLock("jsApiTicketLock");
            }
            case WX_CARD: {
                return this.weChatMpDynamicConfigStorage.getLock("cardApiTicketLock");
            }
        }
        throw new UnsupportedOperationException("ticketType = " + type.name());
    }

    public long getTicketExpiresTime(TicketType type) {
        switch (type) {
            case JSAPI: {
                return this.weChatMpDynamicConfigStorage.getJsapiTicketExpiresTime();
            }
            case WX_CARD: {
                return this.weChatMpDynamicConfigStorage.getCardApiTicketExpiresTime();
            }
        }
        throw new UnsupportedOperationException("ticketType = " + type.name());
    }

    public boolean isTicketExpired(TicketType type) {
        switch (type) {
            case JSAPI: {
                return this.weChatMpDynamicConfigStorage.isJsapiTicketExpired();
            }
            case WX_CARD: {
                return this.weChatMpDynamicConfigStorage.isCardApiTicketExpired();
            }
        }
        throw new UnsupportedOperationException("ticketType = " + type.name());
    }

    public void expireTicket(TicketType type) {
        switch (type) {
            case JSAPI: {
                this.weChatMpDynamicConfigStorage.expireJsapiTicket();
                break;
            }
            case WX_CARD: {
                this.weChatMpDynamicConfigStorage.expireCardApiTicket();
                break;
            }
            default: {
                throw new UnsupportedOperationException("ticketType = " + type.name());
            }
        }
    }

    public void updateTicket(TicketType type, String ticket, int expiresInSeconds) {
        switch (type) {
            case JSAPI: {
                this.weChatMpDynamicConfigStorage.updateJsapiTicket(ticket, expiresInSeconds);
                break;
            }
            case WX_CARD: {
                this.weChatMpDynamicConfigStorage.updateCardApiTicket(ticket, expiresInSeconds);
                break;
            }
            default: {
                throw new UnsupportedOperationException("ticketType = " + type.name());
            }
        }
    }

    public WxMpHostConfig getHostConfig() {
        return null;
    }

    public void setWeChatMp(WeChatMpProperties.WeChatMp weChatMp) {
        this.weChatMp = weChatMp;
    }

    public void setWeChatMpDynamicConfigStorage(WeChatMpDynamicConfigStorage weChatMpDynamicConfigStorage) {
        this.weChatMpDynamicConfigStorage = weChatMpDynamicConfigStorage;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setLockTime(int lockTime) {
        this.lockTime = lockTime;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public WeChatMpProperties.WeChatMp getWeChatMp() {
        return this.weChatMp;
    }

    public WeChatMpDynamicConfigStorage getWeChatMpDynamicConfigStorage() {
        return this.weChatMpDynamicConfigStorage;
    }

    public LockService getLockService() {
        return this.lockService;
    }

    public int getLockTime() {
        return this.lockTime;
    }

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public WeChatMpInRedisConfigStorage(WeChatMpProperties.WeChatMp weChatMp, WeChatMpDynamicConfigStorage weChatMpDynamicConfigStorage, LockService lockService, int lockTime, StringRedisTemplate redisTemplate) {
        this.weChatMp = weChatMp;
        this.weChatMpDynamicConfigStorage = weChatMpDynamicConfigStorage;
        this.lockService = lockService;
        this.lockTime = lockTime;
        this.redisTemplate = redisTemplate;
    }
}

