/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.mp.api.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.mp.api.impl.WxMpServiceOkHttpImpl;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.enums.TicketType;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatMpServiceOkHttpImpl
extends WxMpServiceOkHttpImpl {
    private static final Logger log = LoggerFactory.getLogger(WeChatMpServiceOkHttpImpl.class);
    private static final JsonParser JSON_PARSER = new JsonParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        log.debug("WeChatMpServiceOkHttpImpl getAccessToken is running");
        WxMpConfigStorage wxMpConfigStorage = this.getWxMpConfigStorage();
        if (!forceRefresh && !wxMpConfigStorage.isAccessTokenExpired()) {
            return wxMpConfigStorage.getAccessToken();
        }
        Lock lock = wxMpConfigStorage.getAccessTokenLock();
        try {
            lock.lock();
            String url = String.format(WxMpApiUrl.Other.GET_ACCESS_TOKEN_URL.getUrl(wxMpConfigStorage), this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret());
            Request request = new Request.Builder().url(url).get().build();
            Response response = this.getRequestHttpClient().newCall(request).execute();
            assert (response.body() != null);
            String resultContent = response.body().string();
            WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.MP);
            if (error.getErrorCode() != 0) {
                throw new WxErrorException(error);
            }
            WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
            wxMpConfigStorage.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
            String string = accessToken.getAccessToken();
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTicket(TicketType type, boolean forceRefresh) throws WxErrorException {
        WxMpConfigStorage wxMpConfigStorage = this.getWxMpConfigStorage();
        if (!forceRefresh && !wxMpConfigStorage.isTicketExpired(type)) {
            return wxMpConfigStorage.getTicket(type);
        }
        Lock lock = wxMpConfigStorage.getTicketLock(type);
        try {
            lock.lock();
            String responseContent = (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), WxMpApiUrl.Other.GET_TICKET_URL.getUrl(wxMpConfigStorage) + type.getCode(), null);
            JsonObject tmpJsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
            String ticket = tmpJsonObject.get("ticket").getAsString();
            int expiresInSeconds = tmpJsonObject.get("expires_in").getAsInt();
            wxMpConfigStorage.updateTicket(type, ticket, expiresInSeconds);
            String string = ticket;
            return string;
        }
        finally {
            lock.unlock();
        }
    }
}

