/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.mp.api.impl;

import app.myoss.cloud.cache.lock.LockService;
import app.myoss.cloud.core.exception.BizRuntimeException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;

public class LockService4Jdk
implements Lock {
    @NonNull
    private String key;
    @NonNull
    private LockService lockService;
    private int tryLockTimes = 100;

    @Override
    public void lock() {
        boolean isGetLock = this.tryLock();
        if (!isGetLock) {
            for (int i = 1; i < this.tryLockTimes; ++i) {
                LockService.sleep((long)10L);
                isGetLock = this.tryLock();
                if (isGetLock) break;
            }
        }
        if (!isGetLock) {
            throw new BizRuntimeException("lock failed, key: " + this.key);
        }
    }

    @Override
    public void lockInterruptibly() {
        this.lockService.releaseLock((Serializable)((Object)this.key));
    }

    @Override
    public boolean tryLock() {
        return this.lockService.getLock((Serializable)((Object)this.key), 300);
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        return this.lockService.getLock((Serializable)((Object)this.key), Long.valueOf(unit.toMillis(time)).intValue());
    }

    @Override
    public void unlock() {
        this.lockService.releaseLock((Serializable)((Object)this.key));
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public void setKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
    }

    public void setLockService(@NonNull LockService lockService) {
        if (lockService == null) {
            throw new NullPointerException("lockService is marked non-null but is null");
        }
        this.lockService = lockService;
    }

    public void setTryLockTimes(int tryLockTimes) {
        this.tryLockTimes = tryLockTimes;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public LockService getLockService() {
        return this.lockService;
    }

    public int getTryLockTimes() {
        return this.tryLockTimes;
    }

    public LockService4Jdk(@NonNull String key, @NonNull LockService lockService) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (lockService == null) {
            throw new NullPointerException("lockService is marked non-null but is null");
        }
        this.key = key;
        this.lockService = lockService;
    }
}

