/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.pay.autoconfigure;

import app.myoss.cloud.core.spring.context.SpringContextHolder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="wechat.pay")
public class WeChatPayProperties {
    private boolean enabled;
    private WeChatMp config;
    private Map<String, WeChatMp> configs;

    public WeChatMp getByCustomAppId(String customAppId) {
        if (StringUtils.isBlank((CharSequence)customAppId)) {
            return null;
        }
        if (this.config != null && customAppId.equals(this.config.getCustomAppId())) {
            return this.config;
        }
        for (WeChatMp weChatMp : this.configs.values()) {
            if (!customAppId.equals(weChatMp.getCustomAppId())) continue;
            return weChatMp;
        }
        return null;
    }

    public WeChatMp getByOriginalId(String originalId) {
        if (StringUtils.isBlank((CharSequence)originalId)) {
            return null;
        }
        if (this.config != null && originalId.equals(this.config.getOriginalId())) {
            return this.config;
        }
        for (WeChatMp weChatMp : this.configs.values()) {
            if (!originalId.equals(weChatMp.getAppId())) continue;
            return weChatMp;
        }
        return null;
    }

    public WeChatMp getByAppId(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (this.config != null && appId.equals(this.config.getAppId())) {
            return this.config;
        }
        for (WeChatMp weChatMp : this.configs.values()) {
            if (!appId.equals(weChatMp.getAppId())) continue;
            return weChatMp;
        }
        return null;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WeChatMp getConfig() {
        return this.config;
    }

    public Map<String, WeChatMp> getConfigs() {
        return this.configs;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setConfig(WeChatMp config) {
        this.config = config;
    }

    public void setConfigs(Map<String, WeChatMp> configs) {
        this.configs = configs;
    }

    public static class WeChatMp {
        private String appName;
        private String customAppId;
        private String originalId;
        private String appId;
        @JSONField(serialize=false)
        private String appSecret;
        @JSONField(serialize=false)
        private String token;
        @JSONField(serialize=false)
        private String encodingAesKey;
        @JSONField(serialize=false)
        private String mchId;
        @JSONField(serialize=false)
        private String mchKey;
        private String subMchId;
        private String notifyUrl;
        private String tradeType;
        private String keyPath;
        private String subAppId;

        public <T> T getSpringBeanByCustomAppId(Class<T> clazz) {
            String name = this.customAppId + clazz.getSimpleName();
            return (T)SpringContextHolder.getBean((String)name, clazz);
        }

        public String toString() {
            return JSON.toJSONString((Object)this);
        }

        public String getAppName() {
            return this.appName;
        }

        public String getCustomAppId() {
            return this.customAppId;
        }

        public String getOriginalId() {
            return this.originalId;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        public String getToken() {
            return this.token;
        }

        public String getEncodingAesKey() {
            return this.encodingAesKey;
        }

        public String getMchId() {
            return this.mchId;
        }

        public String getMchKey() {
            return this.mchKey;
        }

        public String getSubMchId() {
            return this.subMchId;
        }

        public String getNotifyUrl() {
            return this.notifyUrl;
        }

        public String getTradeType() {
            return this.tradeType;
        }

        public String getKeyPath() {
            return this.keyPath;
        }

        public String getSubAppId() {
            return this.subAppId;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setCustomAppId(String customAppId) {
            this.customAppId = customAppId;
        }

        public void setOriginalId(String originalId) {
            this.originalId = originalId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setEncodingAesKey(String encodingAesKey) {
            this.encodingAesKey = encodingAesKey;
        }

        public void setMchId(String mchId) {
            this.mchId = mchId;
        }

        public void setMchKey(String mchKey) {
            this.mchKey = mchKey;
        }

        public void setSubMchId(String subMchId) {
            this.subMchId = subMchId;
        }

        public void setNotifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
        }

        public void setTradeType(String tradeType) {
            this.tradeType = tradeType;
        }

        public void setKeyPath(String keyPath) {
            this.keyPath = keyPath;
        }

        public void setSubAppId(String subAppId) {
            this.subAppId = subAppId;
        }
    }
}

