/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.pay.autoconfigure;

import app.myoss.cloud.core.lang.json.JsonApi;
import app.myoss.cloud.core.spring.context.SpringContextHolder;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="wechat.pay")
public class WeChatPayProperties {
    private boolean enabled;
    private WeChatMp config;
    private Map<String, WeChatMp> configs;

    public WeChatMp getByCustomAppId(String customAppId) {
        if (StringUtils.isBlank((CharSequence)customAppId)) {
            return null;
        }
        if (this.config != null && customAppId.equals(this.config.getCustomAppId())) {
            return this.config;
        }
        for (WeChatMp weChatMp : this.configs.values()) {
            if (!customAppId.equals(weChatMp.getCustomAppId())) continue;
            return weChatMp;
        }
        return null;
    }

    public WeChatMp getByOriginalId(String originalId) {
        if (StringUtils.isBlank((CharSequence)originalId)) {
            return null;
        }
        if (this.config != null && originalId.equals(this.config.getOriginalId())) {
            return this.config;
        }
        for (WeChatMp weChatMp : this.configs.values()) {
            if (!originalId.equals(weChatMp.getAppId())) continue;
            return weChatMp;
        }
        return null;
    }

    public WeChatMp getByAppId(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return null;
        }
        if (this.config != null && appId.equals(this.config.getAppId())) {
            return this.config;
        }
        for (WeChatMp weChatMp : this.configs.values()) {
            if (!appId.equals(weChatMp.getAppId())) continue;
            return weChatMp;
        }
        return null;
    }

    public String toString() {
        return JsonApi.toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeChatPayProperties)) {
            return false;
        }
        WeChatPayProperties other = (WeChatPayProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        WeChatMp this$config = this.getConfig();
        WeChatMp other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        Map<String, WeChatMp> this$configs = this.getConfigs();
        Map<String, WeChatMp> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WeChatPayProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        WeChatMp $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        Map<String, WeChatMp> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public WeChatMp getConfig() {
        return this.config;
    }

    public Map<String, WeChatMp> getConfigs() {
        return this.configs;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setConfig(WeChatMp config) {
        this.config = config;
    }

    public void setConfigs(Map<String, WeChatMp> configs) {
        this.configs = configs;
    }

    public static class WeChatMp {
        private String appName;
        private String customAppId;
        private String originalId;
        private String appId;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Expose(serialize=false)
        @JSONField(serialize=false)
        private String appSecret;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Expose(serialize=false)
        @JSONField(serialize=false)
        private String token;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Expose(serialize=false)
        @JSONField(serialize=false)
        private String encodingAesKey;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Expose(serialize=false)
        @JSONField(serialize=false)
        private String mchId;
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        @Expose(serialize=false)
        @JSONField(serialize=false)
        private String mchKey;
        private String subMchId;
        private String notifyUrl;
        private String tradeType;
        private String keyPath;
        private String subAppId;

        public <T> T getSpringBeanByCustomAppId(Class<T> clazz) {
            String name = this.customAppId + clazz.getSimpleName();
            return (T)SpringContextHolder.getBean((String)name, clazz);
        }

        public String toString() {
            return JsonApi.toJson((Object)this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WeChatMp)) {
                return false;
            }
            WeChatMp other = (WeChatMp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$appName = this.getAppName();
            String other$appName = other.getAppName();
            if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
                return false;
            }
            String this$customAppId = this.getCustomAppId();
            String other$customAppId = other.getCustomAppId();
            if (this$customAppId == null ? other$customAppId != null : !this$customAppId.equals(other$customAppId)) {
                return false;
            }
            String this$originalId = this.getOriginalId();
            String other$originalId = other.getOriginalId();
            if (this$originalId == null ? other$originalId != null : !this$originalId.equals(other$originalId)) {
                return false;
            }
            String this$appId = this.getAppId();
            String other$appId = other.getAppId();
            if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                return false;
            }
            String this$appSecret = this.getAppSecret();
            String other$appSecret = other.getAppSecret();
            if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$encodingAesKey = this.getEncodingAesKey();
            String other$encodingAesKey = other.getEncodingAesKey();
            if (this$encodingAesKey == null ? other$encodingAesKey != null : !this$encodingAesKey.equals(other$encodingAesKey)) {
                return false;
            }
            String this$mchId = this.getMchId();
            String other$mchId = other.getMchId();
            if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
                return false;
            }
            String this$mchKey = this.getMchKey();
            String other$mchKey = other.getMchKey();
            if (this$mchKey == null ? other$mchKey != null : !this$mchKey.equals(other$mchKey)) {
                return false;
            }
            String this$subMchId = this.getSubMchId();
            String other$subMchId = other.getSubMchId();
            if (this$subMchId == null ? other$subMchId != null : !this$subMchId.equals(other$subMchId)) {
                return false;
            }
            String this$notifyUrl = this.getNotifyUrl();
            String other$notifyUrl = other.getNotifyUrl();
            if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
                return false;
            }
            String this$tradeType = this.getTradeType();
            String other$tradeType = other.getTradeType();
            if (this$tradeType == null ? other$tradeType != null : !this$tradeType.equals(other$tradeType)) {
                return false;
            }
            String this$keyPath = this.getKeyPath();
            String other$keyPath = other.getKeyPath();
            if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
                return false;
            }
            String this$subAppId = this.getSubAppId();
            String other$subAppId = other.getSubAppId();
            return !(this$subAppId == null ? other$subAppId != null : !this$subAppId.equals(other$subAppId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WeChatMp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $appName = this.getAppName();
            result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
            String $customAppId = this.getCustomAppId();
            result = result * 59 + ($customAppId == null ? 43 : $customAppId.hashCode());
            String $originalId = this.getOriginalId();
            result = result * 59 + ($originalId == null ? 43 : $originalId.hashCode());
            String $appId = this.getAppId();
            result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
            String $appSecret = this.getAppSecret();
            result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $encodingAesKey = this.getEncodingAesKey();
            result = result * 59 + ($encodingAesKey == null ? 43 : $encodingAesKey.hashCode());
            String $mchId = this.getMchId();
            result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
            String $mchKey = this.getMchKey();
            result = result * 59 + ($mchKey == null ? 43 : $mchKey.hashCode());
            String $subMchId = this.getSubMchId();
            result = result * 59 + ($subMchId == null ? 43 : $subMchId.hashCode());
            String $notifyUrl = this.getNotifyUrl();
            result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
            String $tradeType = this.getTradeType();
            result = result * 59 + ($tradeType == null ? 43 : $tradeType.hashCode());
            String $keyPath = this.getKeyPath();
            result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
            String $subAppId = this.getSubAppId();
            result = result * 59 + ($subAppId == null ? 43 : $subAppId.hashCode());
            return result;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getCustomAppId() {
            return this.customAppId;
        }

        public String getOriginalId() {
            return this.originalId;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        public String getToken() {
            return this.token;
        }

        public String getEncodingAesKey() {
            return this.encodingAesKey;
        }

        public String getMchId() {
            return this.mchId;
        }

        public String getMchKey() {
            return this.mchKey;
        }

        public String getSubMchId() {
            return this.subMchId;
        }

        public String getNotifyUrl() {
            return this.notifyUrl;
        }

        public String getTradeType() {
            return this.tradeType;
        }

        public String getKeyPath() {
            return this.keyPath;
        }

        public String getSubAppId() {
            return this.subAppId;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setCustomAppId(String customAppId) {
            this.customAppId = customAppId;
        }

        public void setOriginalId(String originalId) {
            this.originalId = originalId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public void setEncodingAesKey(String encodingAesKey) {
            this.encodingAesKey = encodingAesKey;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public void setMchId(String mchId) {
            this.mchId = mchId;
        }

        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        public void setMchKey(String mchKey) {
            this.mchKey = mchKey;
        }

        public void setSubMchId(String subMchId) {
            this.subMchId = subMchId;
        }

        public void setNotifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
        }

        public void setTradeType(String tradeType) {
            this.tradeType = tradeType;
        }

        public void setKeyPath(String keyPath) {
            this.keyPath = keyPath;
        }

        public void setSubAppId(String subAppId) {
            this.subAppId = subAppId;
        }
    }
}

