/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.WxPayApiData;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.impl.BaseWxPayServiceImpl;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.annotation.PostConstruct;
import javax.net.ssl.X509TrustManager;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeChatPayServiceOkHttpImpl
extends BaseWxPayServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(WeChatPayServiceOkHttpImpl.class);
    private OkHttpClient httpClient;
    private OkHttpProxyInfo httpProxy;

    public OkHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    @PostConstruct
    public void initHttp() {
        WxPayConfig wxPayConfig = this.getConfig();
        if (wxPayConfig.getHttpProxyHost() != null && wxPayConfig.getHttpProxyPort() > 0) {
            this.httpProxy = OkHttpProxyInfo.httpProxy((String)wxPayConfig.getHttpProxyHost(), (int)wxPayConfig.getHttpProxyPort(), (String)wxPayConfig.getHttpProxyUsername(), (String)wxPayConfig.getHttpProxyPassword());
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.httpProxy != null) {
            clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
            clientBuilder.authenticator((route, response) -> {
                String credential = Credentials.basic((String)this.httpProxy.getProxyUsername(), (String)this.httpProxy.getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            });
        }
        this.httpClient = null != wxPayConfig.getSslContext() ? clientBuilder.sslSocketFactory(wxPayConfig.getSslContext().getSocketFactory(), new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }).build() : clientBuilder.build();
    }

    public byte[] postForBytes(String url, String requestStr, boolean useKey) throws WxPayException {
        try {
            RequestBody requestBody = RequestBody.create((String)requestStr, (MediaType)MediaType.get((String)"application/xml"));
            Request request = new Request.Builder().url(url).post(requestBody).build();
            Response response = this.getRequestHttpClient().newCall(request).execute();
            byte[] responseBytes = response.body().bytes();
            String responseString = new String(Base64.getDecoder().decode(responseBytes), StandardCharsets.UTF_8);
            log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e(Base64\u7f16\u7801\u540e)\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                wxApiData.set(new WxPayApiData(url, requestStr, responseString, null));
            }
            return responseBytes;
        }
        catch (Exception e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            wxApiData.set(new WxPayApiData(url, requestStr, null, e.getMessage()));
            throw new WxPayException(e.getMessage(), (Throwable)e);
        }
    }

    public String post(String url, String requestStr, boolean useKey) throws WxPayException {
        try {
            RequestBody requestBody = RequestBody.create((String)requestStr, (MediaType)MediaType.get((String)"application/xml"));
            Request request = new Request.Builder().url(url).post(requestBody).build();
            Response response = this.getRequestHttpClient().newCall(request).execute();
            String responseString = response.body().string();
            if (StringUtils.isBlank((CharSequence)responseString)) {
                throw new WxPayException("\u54cd\u5e94\u4fe1\u606f\u4e3a\u7a7a");
            }
            log.info("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{url, requestStr, responseString});
            if (this.getConfig().isIfSaveApiData()) {
                wxApiData.set(new WxPayApiData(url, requestStr, responseString, null));
            }
            return responseString;
        }
        catch (Exception e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011\uff1a{}\n\u3010\u8bf7\u6c42\u6570\u636e\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{url, requestStr, e.getMessage()});
            wxApiData.set(new WxPayApiData(url, requestStr, null, e.getMessage()));
            throw new WxPayException(e.getMessage(), (Throwable)e);
        }
    }
}

