/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.pay.autoconfigure;

import app.myoss.wechat.pay.autoconfigure.WeChatPayProperties;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WeChatPayServiceOkHttpImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={WeChatPayProperties.class})
@ConditionalOnProperty(prefix="wechat.pay", value={"enabled"}, matchIfMissing=false)
@Configuration
public class WeChatPayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WeChatPayAutoConfiguration.class);

    @ConditionalOnMissingBean
    @Bean
    public WxPayService wxPayService(WeChatPayProperties weChatPayProperties) {
        WeChatPayProperties.WeChatMp config = weChatPayProperties.getConfig();
        WxPayConfig payConfig = new WxPayConfig();
        WeChatPayServiceOkHttpImpl wxPayService = new WeChatPayServiceOkHttpImpl();
        wxPayService.setConfig(payConfig);
        payConfig.setAppId(config.getAppId());
        payConfig.setMchId(config.getMchId());
        payConfig.setMchKey(config.getMchKey());
        payConfig.setNotifyUrl(config.getNotifyUrl());
        payConfig.setTradeType(config.getTradeType());
        payConfig.setKeyPath(config.getKeyPath());
        payConfig.setSubMchId(config.getSubMchId());
        payConfig.setSubAppId(config.getSubAppId());
        if (StringUtils.isNotBlank((CharSequence)config.getKeyPath())) {
            try {
                payConfig.setSslContext(payConfig.initSSLContext());
            }
            catch (WxPayException e) {
                log.info("\u83b7\u53d6SslContext\u5f02\u5e38:{}", (Throwable)e);
            }
        }
        return wxPayService;
    }
}

