/*
 * Decompiled with CFR 0.152.
 */
package app.nzyme.plugin;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class Notification {
    private final ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder();
    private final String message;

    public Notification(String message, int channel) {
        this.message = message;
        this.addField("channel", channel);
    }

    public Notification addField(String key, Object value) {
        if (value == null) {
            return this;
        }
        this.fields.put((Object)key, value);
        return this;
    }

    public Notification addFields(Map<String, Object> x) {
        if (x == null) {
            return this;
        }
        this.fields.putAll(x);
        return this;
    }

    public Map<String, Object> getAdditionalFields() {
        return this.fields.build();
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("802.11 frame: ").append(this.message).append(" - Details: ").append(Joiner.on((String)", ").join(this.getAdditionalFields().entrySet()));
        return sb.toString();
    }
}

