/*
 * Decompiled with CFR 0.152.
 */
package app.nzyme.plugin.rest.configuration;

import app.nzyme.plugin.rest.configuration.AutoValue_ConfigurationEntryConstraint;
import app.nzyme.plugin.rest.configuration.EnumStringsConstraint;
import app.nzyme.plugin.rest.configuration.ExactStringLengthConstraint;
import app.nzyme.plugin.rest.configuration.NumberRangeConstraint;
import app.nzyme.plugin.rest.configuration.StringLengthConstraint;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class ConfigurationEntryConstraint {
    @JsonProperty(value="type")
    public abstract ConstraintType type();

    @JsonProperty(value="data")
    @Nullable
    public abstract Object data();

    public static ConfigurationEntryConstraint createStringLengthConstraint(int min, int max) {
        return ConfigurationEntryConstraint.builder().type(ConstraintType.STRING_LENGTH).data(StringLengthConstraint.create(min, max)).build();
    }

    public static ConfigurationEntryConstraint createExactStringLengthConstraint(int length) {
        return ConfigurationEntryConstraint.builder().type(ConstraintType.EXACT_STRING_LENGTH).data(ExactStringLengthConstraint.create(length)).build();
    }

    public static ConfigurationEntryConstraint createNumberRangeConstraint(int min, int max) {
        return ConfigurationEntryConstraint.builder().type(ConstraintType.NUMBER_RANGE).data(NumberRangeConstraint.create(min, max)).build();
    }

    public static ConfigurationEntryConstraint createSimpleBooleanConstraint() {
        return ConfigurationEntryConstraint.builder().type(ConstraintType.SIMPLE_BOOLEAN).data(null).build();
    }

    public static ConfigurationEntryConstraint createEnumStringsConstraint(List<String> enums) {
        return ConfigurationEntryConstraint.builder().type(ConstraintType.ENUM_STRINGS).data(EnumStringsConstraint.create(enums)).build();
    }

    public static ConfigurationEntryConstraint createHttpUrlConstraint() {
        return ConfigurationEntryConstraint.builder().type(ConstraintType.URI).data(null).build();
    }

    public static Builder builder() {
        return new AutoValue_ConfigurationEntryConstraint.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder type(ConstraintType var1);

        public abstract Builder data(Object var1);

        public abstract ConfigurationEntryConstraint build();
    }

    static enum ConstraintType {
        STRING_LENGTH,
        EXACT_STRING_LENGTH,
        NUMBER_RANGE,
        SIMPLE_BOOLEAN,
        ENUM_STRINGS,
        URI;

    }
}

