/*
 * Decompiled with CFR 0.152.
 */
package app.nzyme.plugin.distributed.messaging;

import app.nzyme.plugin.distributed.messaging.AutoValue_StoredMessage;
import app.nzyme.plugin.distributed.messaging.MessageStatus;
import app.nzyme.plugin.distributed.messaging.MessageType;
import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@AutoValue
public abstract class StoredMessage {
    public abstract Long id();

    public abstract UUID sender();

    public abstract UUID receiver();

    public abstract MessageType type();

    public abstract Map<String, Object> parameters();

    public abstract MessageStatus status();

    public abstract DateTime createdAt();

    @Nullable
    public abstract Long cycleLimiter();

    @Nullable
    public abstract DateTime acknowledgedAt();

    @Nullable
    public abstract Integer processingTimeMs();

    public static StoredMessage create(Long id, UUID sender, UUID receiver, MessageType type, Map<String, Object> parameters, MessageStatus status, DateTime createdAt, Long cycleLimiter, DateTime acknowledgedAt, Integer processingTimeMs) {
        return StoredMessage.builder().id(id).sender(sender).receiver(receiver).type(type).parameters(parameters).status(status).createdAt(createdAt).cycleLimiter(cycleLimiter).acknowledgedAt(acknowledgedAt).processingTimeMs(processingTimeMs).build();
    }

    public static Builder builder() {
        return new AutoValue_StoredMessage.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(Long var1);

        public abstract Builder sender(UUID var1);

        public abstract Builder receiver(UUID var1);

        public abstract Builder type(MessageType var1);

        public abstract Builder parameters(Map<String, Object> var1);

        public abstract Builder status(MessageStatus var1);

        public abstract Builder createdAt(DateTime var1);

        public abstract Builder cycleLimiter(Long var1);

        public abstract Builder acknowledgedAt(DateTime var1);

        public abstract Builder processingTimeMs(Integer var1);

        public abstract StoredMessage build();
    }
}

