/*
 * Decompiled with CFR 0.152.
 */
package app.nzyme.plugin.distributed.tasksqueue;

import app.nzyme.plugin.distributed.tasksqueue.AutoValue_StoredTask;
import app.nzyme.plugin.distributed.tasksqueue.TaskStatus;
import app.nzyme.plugin.distributed.tasksqueue.TaskType;
import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@AutoValue
public abstract class StoredTask {
    public abstract Long id();

    public abstract UUID sender();

    public abstract TaskType type();

    public abstract Boolean allowRetry();

    public abstract Map<String, Object> parameters();

    public abstract DateTime createdAt();

    public abstract TaskStatus status();

    public abstract Integer retries();

    public abstract boolean allowProcessSelf();

    @Nullable
    public abstract TaskStatus previousStatus();

    @Nullable
    public abstract Integer processingTimeMs();

    @Nullable
    public abstract DateTime firstProcessedAt();

    @Nullable
    public abstract DateTime lastProcessedAt();

    @Nullable
    public abstract UUID processedBy();

    public static StoredTask create(Long id, UUID sender, TaskType type, Boolean allowRetry, Map<String, Object> parameters, DateTime createdAt, TaskStatus status, Integer retries, boolean allowProcessSelf, TaskStatus previousStatus, Integer processingTimeMs, DateTime firstProcessedAt, DateTime lastProcessedAt, UUID processedBy) {
        return StoredTask.builder().id(id).sender(sender).type(type).allowRetry(allowRetry).parameters(parameters).createdAt(createdAt).status(status).retries(retries).allowProcessSelf(allowProcessSelf).previousStatus(previousStatus).processingTimeMs(processingTimeMs).firstProcessedAt(firstProcessedAt).lastProcessedAt(lastProcessedAt).processedBy(processedBy).build();
    }

    public static Builder builder() {
        return new AutoValue_StoredTask.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(Long var1);

        public abstract Builder sender(UUID var1);

        public abstract Builder type(TaskType var1);

        public abstract Builder allowRetry(Boolean var1);

        public abstract Builder parameters(Map<String, Object> var1);

        public abstract Builder createdAt(DateTime var1);

        public abstract Builder status(TaskStatus var1);

        public abstract Builder retries(Integer var1);

        public abstract Builder allowProcessSelf(boolean var1);

        public abstract Builder previousStatus(TaskStatus var1);

        public abstract Builder processingTimeMs(Integer var1);

        public abstract Builder firstProcessedAt(DateTime var1);

        public abstract Builder lastProcessedAt(DateTime var1);

        public abstract Builder processedBy(UUID var1);

        public abstract StoredTask build();
    }
}

