package app.peac.core.model.javafx.table;

import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;

public class CheckBoxCell<T> extends TableCell<T, T> {

    private final ObservableList<T> selectedItems;
    private final CheckBox checkBox;

    public CheckBoxCell(ObservableList<T> selectedItems) {
        this.selectedItems = selectedItems;
        this.checkBox = new CheckBox();
        checkBox.setAlignment(Pos.CENTER);

        checkBox.setOnAction(event -> {
            if (checkBox.isSelected()) {
                selectedItems.add(getItem());
            } else {
                selectedItems.remove(getItem());
            }
        });

        selectedItems.addListener((ListChangeListener<T>) change -> {
            T item = getItem();
            if (item != null) {
                checkBox.setSelected(selectedItems.contains(item));
            }
        });
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            setGraphic(null);
        } else {
            checkBox.setSelected(selectedItems.contains(item));
            setGraphic(checkBox);
        }
    }
}