package app.peac.core.model.rpa;

import lombok.Builder;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

@Getter
@Builder
public class RpaDriverConfig {

    private RpaDriverType driverType;
    private String userDataPath;
    private boolean runHeadless;

    public static RpaDriverConfig def() {
        return RpaDriverConfig.builder()
                .driverType(RpaDriverType.CHROME)
                .userDataPath(null)
                .runHeadless(true)
                .build();
    }

    public boolean isUserDataExists() {
        return StringUtils.isNotBlank(userDataPath);
    }
}
