package app.peac.core.utils.date;

import lombok.experimental.UtilityClass;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

@UtilityClass
public class DateFormatUtils {

    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MMM dd, YYYY HH:mm:ss");

    public static String formatDate(LocalDateTime dateTime) {
        if (Objects.isNull(dateTime))
            return "";
        else
            return dateTime.format(DATE_TIME_FORMATTER);
    }
}
