package app.peac.core.utils.rpa;

import javafx.concurrent.Task;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Slf4j
@UtilityClass
public class RpaThreadUtils {

    private static final ExecutorService THREADS = Executors.newSingleThreadExecutor();
    private static Future<?> currentFuture;

    public synchronized static Future<?> createRpaThread(Task<?> task) {
        log.info("Creating new RPA thread");
        if (currentFuture != null) {
            log.info("Previous RPA thread is still running");
            currentFuture.cancel(true);
            log.info("Previous RPA thread cancelled");
        }
        currentFuture = THREADS.submit(task);
        log.info("New RPA thread created");
        return currentFuture;
    }
}
