package app.peac.core.utils.rpa.driver;

import app.peac.core.model.rpa.RpaDriverConfig;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

@Slf4j
@UtilityClass
public class ChromeDriverUtils {

    public static WebDriver createChromeDriver(RpaDriverConfig config) {
        log.info("Creating ChromeDriver");
        log.info("RunHeadless: {}", config.isRunHeadless());

        var options = new ChromeOptions();
        options.addArguments(ChromiumDriverUtils.getCommonDriverOptions());

        if (config.isUserDataExists()) {
            options.addArguments("user-data-dir=" + config.getUserDataPath());
        }

        if (config.isRunHeadless()) {
            options.addArguments("--headless");
        } else {
            options.addArguments("--start-maximized");
        }

        log.info("Chrome Driver Options are ready");

        return new ChromeDriver(options);
    }
}
