package app.peac.core.utils.rpa.driver;

import app.peac.core.model.rpa.RpaDriverConfig;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;

import java.io.File;

@Slf4j
@UtilityClass
public class FirefoxDriverUtils {

    public static WebDriver createFirefoxDriver(RpaDriverConfig config) {
        log.info("Creating ChromeDriver");
        log.info("UserDataPath: {}", config.getUserDataPath());
        log.info("RunHeadless: {}", config.isRunHeadless());

        var options = new FirefoxOptions();

        if (config.isUserDataExists()) {
            var profileDir = new File(config.getUserDataPath());
            var profile = new FirefoxProfile(profileDir);
            profile.setAcceptUntrustedCertificates(true);
            options.setProfile(profile);
        }

        if (config.isRunHeadless()) {
            options.addArguments("-headless");
        }

        log.info("Firefox Driver Options are ready");

        return new FirefoxDriver(options);
    }
}
