/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.model.javafx.format;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;

public class NumberFormatter
extends TextFormatter<Number> {
    private static final List<String> INTEGER_CLASSES = List.of(Byte.class.getSimpleName(), Short.class.getSimpleName(), Integer.class.getSimpleName(), Long.class.getSimpleName());
    private static final List<String> FRACTIONAL_CLASSES = List.of(Float.class.getSimpleName(), Double.class.getSimpleName());
    private static final DecimalFormat INTEGER_DECIMAL_FORMAT = new DecimalFormat("0");
    private static final DecimalFormat FRACTIONAL_DECIMAL_FORMAT = new DecimalFormat("0.00");

    public NumberFormatter(final Class<? extends Number> numberClass) {
        super(new StringConverter<Number>(){

            @Override
            public String toString(Number value) {
                return NumberFormatter.getFormatForClass(numberClass).format(value);
            }

            @Override
            public Number fromString(String string) {
                try {
                    return NumberFormatter.getFormatForClass(numberClass).parse(string).doubleValue();
                }
                catch (ParseException e) {
                    return null;
                }
            }
        }, 0, change -> {
            try {
                NumberFormatter.getFormatForClass(numberClass).parse(change.getControlNewText());
                return change;
            }
            catch (ParseException e) {
                return null;
            }
        });
    }

    private static DecimalFormat getFormatForClass(Class<? extends Number> numberClass) {
        if (INTEGER_CLASSES.contains(numberClass.getSimpleName())) {
            return INTEGER_DECIMAL_FORMAT;
        }
        if (FRACTIONAL_CLASSES.contains(numberClass.getSimpleName())) {
            return FRACTIONAL_DECIMAL_FORMAT;
        }
        throw new IllegalArgumentException("Such class cannot be formatted: " + numberClass.getSimpleName());
    }
}

