/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.model.javafx.table;

import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableCell;

public class CheckBoxCell<T>
extends TableCell<T, T> {
    private final ObservableList<T> selectedItems;
    private final CheckBox checkBox;

    public CheckBoxCell(ObservableList<T> selectedItems) {
        this.selectedItems = selectedItems;
        this.checkBox = new CheckBox();
        this.checkBox.setAlignment(Pos.CENTER);
        this.checkBox.setOnAction(event -> {
            if (this.checkBox.isSelected()) {
                selectedItems.add(this.getItem());
            } else {
                selectedItems.remove(this.getItem());
            }
        });
        selectedItems.addListener(change -> {
            Object item = this.getItem();
            if (item != null) {
                this.checkBox.setSelected(selectedItems.contains(item));
            }
        });
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.checkBox.setSelected(this.selectedItems.contains(item));
            this.setGraphic(this.checkBox);
        }
    }
}

