/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.model.javafx.table;

import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;

public abstract class ClickableTableRow<T>
extends TableRow<T> {
    protected ClickableTableRow() {
        this.setOnMouseClicked(event -> {
            if (this.isEmpty()) {
                return;
            }
            switch (event.getButton()) {
                case PRIMARY: {
                    this.processPrimaryButtonClick((MouseEvent)event);
                    break;
                }
                case MIDDLE: {
                    this.processMiddleButtonClick((MouseEvent)event);
                    break;
                }
                case SECONDARY: {
                    this.processSecondaryButtonClick((MouseEvent)event);
                }
            }
        });
    }

    private void processPrimaryButtonClick(MouseEvent event) {
        if (event.getClickCount() > 1) {
            this.fireDoubleClickEvent(this.getItem());
        } else {
            this.fireOneClickEvent(this.getItem());
        }
    }

    private void processMiddleButtonClick(MouseEvent event) {
        this.fireMiddleButtonClickEvent(this.getItem());
    }

    private void processSecondaryButtonClick(MouseEvent event) {
        this.fireRightButtonClickEvent(this.getItem());
    }

    protected void fireOneClickEvent(T item) {
    }

    protected void fireDoubleClickEvent(T item) {
    }

    protected void fireMiddleButtonClickEvent(T item) {
    }

    protected void fireRightButtonClickEvent(T item) {
    }
}

