/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.model.rpa;

import app.peac.core.model.rpa.RpaDriverType;
import org.apache.commons.lang3.StringUtils;

public class RpaDriverConfig {
    private RpaDriverType driverType;
    private String userDataPath;
    private boolean runHeadless;

    public static RpaDriverConfig def() {
        return RpaDriverConfig.builder().driverType(RpaDriverType.CHROME).userDataPath(null).runHeadless(true).build();
    }

    public boolean isUserDataExists() {
        return StringUtils.isNotBlank(this.userDataPath);
    }

    RpaDriverConfig(RpaDriverType driverType, String userDataPath, boolean runHeadless) {
        this.driverType = driverType;
        this.userDataPath = userDataPath;
        this.runHeadless = runHeadless;
    }

    public static RpaDriverConfigBuilder builder() {
        return new RpaDriverConfigBuilder();
    }

    public RpaDriverType getDriverType() {
        return this.driverType;
    }

    public String getUserDataPath() {
        return this.userDataPath;
    }

    public boolean isRunHeadless() {
        return this.runHeadless;
    }

    public static class RpaDriverConfigBuilder {
        private RpaDriverType driverType;
        private String userDataPath;
        private boolean runHeadless;

        RpaDriverConfigBuilder() {
        }

        public RpaDriverConfigBuilder driverType(RpaDriverType driverType) {
            this.driverType = driverType;
            return this;
        }

        public RpaDriverConfigBuilder userDataPath(String userDataPath) {
            this.userDataPath = userDataPath;
            return this;
        }

        public RpaDriverConfigBuilder runHeadless(boolean runHeadless) {
            this.runHeadless = runHeadless;
            return this;
        }

        public RpaDriverConfig build() {
            return new RpaDriverConfig(this.driverType, this.userDataPath, this.runHeadless);
        }

        public String toString() {
            return "RpaDriverConfig.RpaDriverConfigBuilder(driverType=" + this.driverType + ", userDataPath=" + this.userDataPath + ", runHeadless=" + this.runHeadless + ")";
        }
    }
}

